/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.google.api.core.ApiFutureCallback;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.replication.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PubsubCallback
implements ApiFutureCallback<String> {
    public static final Logger LOGGER = LoggerFactory.getLogger(PubsubCallback.class);
    private final AbstractAsyncProducer.CallbackCompleter cc;
    private final Position position;
    private final String json;
    private MaxwellContext context;
    private Counter succeededMessageCount;
    private Counter failedMessageCount;
    private Meter succeededMessageMeter;
    private Meter failedMessageMeter;

    public PubsubCallback(AbstractAsyncProducer.CallbackCompleter cc, Position position, String json, Counter producedMessageCount, Counter failedMessageCount, Meter succeededMessageMeter, Meter failedMessageMeter, MaxwellContext context) {
        this.cc = cc;
        this.position = position;
        this.json = json;
        this.succeededMessageCount = producedMessageCount;
        this.failedMessageCount = failedMessageCount;
        this.succeededMessageMeter = succeededMessageMeter;
        this.failedMessageMeter = failedMessageMeter;
        this.context = context;
    }

    public void onSuccess(String messageId) {
        this.succeededMessageCount.inc();
        this.succeededMessageMeter.mark();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("->  {}\n    {}\n", (Object)this.json, (Object)this.position);
        }
        this.cc.markCompleted();
    }

    public void onFailure(Throwable t) {
        this.failedMessageCount.inc();
        this.failedMessageMeter.mark();
        LOGGER.error(t.getClass().getSimpleName() + " @ " + this.position);
        LOGGER.error(t.getLocalizedMessage());
        if (!this.context.getConfig().ignoreProducerError) {
            this.context.terminate(new RuntimeException(t));
            return;
        }
        this.cc.markCompleted();
    }
}

