/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.replication.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SNSCallback
implements AsyncHandler<PublishRequest, PublishResult> {
    public static final Logger logger = LoggerFactory.getLogger(SNSCallback.class);
    private final AbstractAsyncProducer.CallbackCompleter cc;
    private final Position position;
    private final String json;
    private MaxwellContext context;

    public SNSCallback(AbstractAsyncProducer.CallbackCompleter cc, Position position, String json, MaxwellContext context) {
        this.cc = cc;
        this.position = position;
        this.json = json;
        this.context = context;
    }

    public void onError(Exception t) {
        logger.error(t.getClass().getSimpleName() + " @ " + this.position + " -- ");
        logger.error(t.getLocalizedMessage());
        logger.error("Exception during put", (Throwable)t);
        if (!this.context.getConfig().ignoreProducerError) {
            this.context.terminate(new RuntimeException(t));
        } else {
            this.cc.markCompleted();
        }
    }

    public void onSuccess(PublishRequest request, PublishResult result) {
        if (logger.isDebugEnabled()) {
            logger.debug("-> MessageId: {}", (Object)result.getMessageId());
        }
        this.cc.markCompleted();
    }
}

