/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.recovery;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.MaxwellMysqlConfig;
import com.zendesk.maxwell.monitoring.NoOpMetrics;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.recovery.RecoveryFilter;
import com.zendesk.maxwell.recovery.RecoveryInfo;
import com.zendesk.maxwell.recovery.RecoverySchemaStore;
import com.zendesk.maxwell.replication.BinlogConnectorReplicator;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.HeartbeatNotifier;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.replication.Replicator;
import com.zendesk.maxwell.row.HeartbeatRowMap;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.util.ConnectionPool;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recovery {
    static final Logger LOGGER = LoggerFactory.getLogger(Recovery.class);
    private final ConnectionPool replicationConnectionPool;
    private final RecoveryInfo recoveryInfo;
    private final MaxwellMysqlConfig replicationConfig;
    private final String maxwellDatabaseName;
    private final RecoverySchemaStore schemaStore;

    public Recovery(MaxwellMysqlConfig replicationConfig, String maxwellDatabaseName, ConnectionPool replicationConnectionPool, CaseSensitivity caseSensitivity, RecoveryInfo recoveryInfo) {
        this.replicationConfig = replicationConfig;
        this.replicationConnectionPool = replicationConnectionPool;
        this.recoveryInfo = recoveryInfo;
        this.schemaStore = new RecoverySchemaStore(replicationConnectionPool, maxwellDatabaseName, caseSensitivity);
        this.maxwellDatabaseName = maxwellDatabaseName;
    }

    public HeartbeatRowMap recover() throws Exception {
        String recoveryMsg = String.format("old-server-id: %d, position: %s", this.recoveryInfo.serverID, this.recoveryInfo.position);
        LOGGER.warn("attempting to recover from master-change: " + recoveryMsg);
        List<BinlogPosition> list = this.getBinlogInfo();
        for (int i = list.size() - 1; i >= 0; --i) {
            BinlogPosition binlogPosition = list.get(i);
            Position position = Position.valueOf(binlogPosition, this.recoveryInfo.getHeartbeat());
            NoOpMetrics metrics = new NoOpMetrics();
            LOGGER.debug("scanning binlog: {}", (Object)binlogPosition);
            BinlogConnectorReplicator replicator = new BinlogConnectorReplicator(this.schemaStore, null, null, this.replicationConfig, 0L, this.maxwellDatabaseName, metrics, position, true, this.recoveryInfo.clientID, new HeartbeatNotifier(), null, new RecoveryFilter(this.maxwellDatabaseName), new MaxwellOutputConfig(), 0.25f, 1);
            HeartbeatRowMap h = this.findHeartbeat(replicator);
            if (h == null) continue;
            LOGGER.warn("recovered new master position: " + h.getNextPosition());
            return h;
        }
        LOGGER.error("Could not recover from master-change: " + recoveryMsg);
        return null;
    }

    private HeartbeatRowMap findHeartbeat(Replicator r) throws Exception {
        r.startReplicator();
        RowMap row = r.getRow();
        while (row != null) {
            HeartbeatRowMap heartbeatRow;
            if (row instanceof HeartbeatRowMap && (heartbeatRow = (HeartbeatRowMap)row).getPosition().getLastHeartbeatRead() == this.recoveryInfo.getHeartbeat()) {
                return heartbeatRow;
            }
            row = r.getRow();
        }
        return null;
    }

    private List<BinlogPosition> getBinlogInfo() throws SQLException {
        ArrayList<BinlogPosition> list = new ArrayList<BinlogPosition>();
        try (Connection c = this.replicationConnectionPool.getConnection();
             Statement s = c.createStatement();
             ResultSet rs = s.executeQuery("SHOW BINARY LOGS");){
            while (rs.next()) {
                list.add(BinlogPosition.at(4L, rs.getString("Log_name")));
            }
        }
        return list;
    }
}

