/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.recovery;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.SchemaCapturer;
import com.zendesk.maxwell.schema.SchemaStore;
import com.zendesk.maxwell.schema.SchemaStoreException;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;
import com.zendesk.maxwell.util.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RecoverySchemaStore
implements SchemaStore {
    private ConnectionPool replicationConnectionPool;
    private String maxwellDatabaseName;
    private CaseSensitivity caseSensitivity;
    private Schema maxwellOnlySchema;

    public RecoverySchemaStore(ConnectionPool replicationConnectionPool, String maxwellDatabaseName, CaseSensitivity caseSensitivity) {
        this.replicationConnectionPool = replicationConnectionPool;
        this.maxwellDatabaseName = maxwellDatabaseName;
        this.caseSensitivity = caseSensitivity;
    }

    @Override
    public Schema getSchema() throws SchemaStoreException {
        if (this.maxwellOnlySchema != null) {
            return this.maxwellOnlySchema;
        }
        try (Connection conn = this.replicationConnectionPool.getConnection();){
            SchemaCapturer capturer = new SchemaCapturer(conn, this.caseSensitivity, this.maxwellDatabaseName);
            this.maxwellOnlySchema = capturer.capture();
        }
        catch (SQLException e) {
            throw new SchemaStoreException(e);
        }
        return this.maxwellOnlySchema;
    }

    @Override
    public List<ResolvedSchemaChange> processSQL(String sql, String currentDatabase, Position position) throws SchemaStoreException, InvalidSchemaError {
        return new ArrayList<ResolvedSchemaChange>();
    }

    @Override
    public Long getSchemaID() throws SchemaStoreException {
        return new Long(0L);
    }
}

