/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.replication;

import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.MaxwellMysqlConfig;
import com.zendesk.maxwell.monitoring.MaxwellDiagnostic;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticResult;
import com.zendesk.maxwell.replication.HeartbeatNotifier;
import java.time.Clock;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CompletableFuture;

public class BinlogConnectorDiagnostic
implements MaxwellDiagnostic {
    private final MaxwellContext context;

    public BinlogConnectorDiagnostic(MaxwellContext context) {
        this.context = context;
    }

    @Override
    public String getName() {
        return "binlog-connector";
    }

    @Override
    public CompletableFuture<MaxwellDiagnosticResult.Check> check() {
        return ((CompletableFuture)this.getLatency().thenApply(this::normalResult)).exceptionally(this::exceptionResult);
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public String getResource() {
        MaxwellMysqlConfig mysql = this.context.getConfig().maxwellMysql;
        return mysql.host + ":" + mysql.port;
    }

    public CompletableFuture<Long> getLatency() {
        HeartbeatObserver observer = new HeartbeatObserver(this.context.getHeartbeatNotifier(), Clock.systemUTC());
        try {
            this.context.heartbeat();
        }
        catch (Exception e) {
            observer.fail(e);
        }
        return observer.latency;
    }

    private MaxwellDiagnosticResult.Check normalResult(Long latency) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("message", "Binlog replication lag is " + latency.toString() + "ms");
        return new MaxwellDiagnosticResult.Check(this, true, info);
    }

    private MaxwellDiagnosticResult.Check exceptionResult(Throwable e) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("error", e.getCause().toString());
        return new MaxwellDiagnosticResult.Check(this, false, info);
    }

    static class HeartbeatObserver
    implements Observer {
        final CompletableFuture<Long> latency;
        private final HeartbeatNotifier notifier;
        private final Clock clock;

        HeartbeatObserver(HeartbeatNotifier notifier, Clock clock) {
            this.notifier = notifier;
            this.clock = clock;
            this.latency = new CompletableFuture();
            this.latency.whenComplete((value, exception) -> this.close());
            notifier.addObserver(this);
        }

        @Override
        public void update(Observable o, Object arg) {
            long heartbeatReadTime = this.clock.millis();
            long latestHeartbeat = (Long)arg;
            this.latency.complete(heartbeatReadTime - latestHeartbeat);
        }

        void fail(Exception e) {
            this.latency.completeExceptionally(e);
        }

        private void close() {
            this.notifier.deleteObserver(this);
        }
    }
}

