/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.replication;

import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.MariadbGtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.event.XidEventData;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BinlogConnectorEvent {
    public static final String BEGIN = "BEGIN";
    public static final String COMMIT = "COMMIT";
    public static final String SAVEPOINT = "SAVEPOINT";
    private final MaxwellOutputConfig outputConfig;
    private BinlogPosition position;
    private BinlogPosition nextPosition;
    private final Event event;
    private final String gtidSetStr;
    private final String gtid;

    public BinlogConnectorEvent(Event event, String filename, String gtidSetStr, String gtid, MaxwellOutputConfig outputConfig) {
        this.event = event;
        this.gtidSetStr = gtidSetStr;
        this.gtid = gtid;
        EventHeaderV4 hV4 = (EventHeaderV4)event.getHeader();
        this.nextPosition = new BinlogPosition(gtidSetStr, gtid, hV4.getNextPosition(), filename);
        this.position = new BinlogPosition(gtidSetStr, gtid, hV4.getPosition(), filename);
        this.outputConfig = outputConfig;
    }

    public Event getEvent() {
        return this.event;
    }

    public WriteRowsEventData writeRowsData() {
        return (WriteRowsEventData)this.event.getData();
    }

    public UpdateRowsEventData updateRowsData() {
        return (UpdateRowsEventData)this.event.getData();
    }

    public DeleteRowsEventData deleteRowsData() {
        return (DeleteRowsEventData)this.event.getData();
    }

    public QueryEventData queryData() {
        return (QueryEventData)this.event.getData();
    }

    public XidEventData xidData() {
        return (XidEventData)this.event.getData();
    }

    public TableMapEventData tableMapData() {
        return (TableMapEventData)this.event.getData();
    }

    public MariadbGtidEventData mariaGtidData() {
        return (MariadbGtidEventData)this.event.getData();
    }

    public BinlogPosition getPosition() {
        return this.position;
    }

    public BinlogPosition getNextPosition() {
        return this.nextPosition;
    }

    public EventType getType() {
        return this.event.getHeader().getEventType();
    }

    public Long getTableID() {
        EventData data = this.event.getData();
        switch (this.event.getHeader().getEventType()) {
            case EXT_WRITE_ROWS: 
            case WRITE_ROWS: {
                return ((WriteRowsEventData)data).getTableId();
            }
            case EXT_UPDATE_ROWS: 
            case UPDATE_ROWS: {
                return ((UpdateRowsEventData)data).getTableId();
            }
            case EXT_DELETE_ROWS: 
            case DELETE_ROWS: {
                return ((DeleteRowsEventData)data).getTableId();
            }
            case TABLE_MAP: {
                return ((TableMapEventData)data).getTableId();
            }
        }
        return null;
    }

    public boolean isCommitEvent() {
        EventType eventType = this.getType();
        if (eventType == EventType.XID) {
            return true;
        }
        if (eventType == EventType.QUERY) {
            return COMMIT.equals(this.queryData().getSql());
        }
        return false;
    }

    private void writeData(Table table, RowMap row, Serializable[] data, BitSet includedColumns) throws ColumnDefCastException {
        int dataIdx = 0;
        int colIdx = 0;
        for (ColumnDef cd : table.getColumnList()) {
            if (includedColumns.get(colIdx)) {
                Object json = null;
                if (data[dataIdx] != null) {
                    json = cd.asJSON(data[dataIdx], this.outputConfig);
                }
                row.putData(cd.getName(), json);
                ++dataIdx;
            }
            ++colIdx;
        }
    }

    private void writeOldData(Table table, RowMap row, Serializable[] oldData, BitSet oldIncludedColumns) throws ColumnDefCastException {
        int dataIdx = 0;
        int colIdx = 0;
        for (ColumnDef cd : table.getColumnList()) {
            if (oldIncludedColumns.get(colIdx)) {
                Object json = null;
                if (oldData[dataIdx] != null) {
                    json = cd.asJSON(oldData[dataIdx], this.outputConfig);
                }
                if (!row.hasData(cd.getName())) {
                    row.putData(cd.getName(), json);
                } else if (!Objects.equals(row.getData(cd.getName()), json)) {
                    row.putOldData(cd.getName(), json);
                }
                ++dataIdx;
            }
            ++colIdx;
        }
    }

    private RowMap buildRowMap(String type, Position position, Position nextPosition, Serializable[] data, Table table, BitSet includedColumns, String rowQuery) throws ColumnDefCastException {
        RowMap map = new RowMap(type, table.getDatabase(), table.getName(), this.event.getHeader().getTimestamp(), table.getPKList(), position, nextPosition, rowQuery);
        this.writeData(table, map, data, includedColumns);
        return map;
    }

    public List<RowMap> jsonMaps(Table table, long lastHeartbeatRead, String rowQuery) throws ColumnDefCastException {
        ArrayList<RowMap> list = new ArrayList<RowMap>();
        Position position = Position.valueOf(this.position, lastHeartbeatRead);
        Position nextPosition = Position.valueOf(this.nextPosition, lastHeartbeatRead);
        switch (this.getType()) {
            case EXT_WRITE_ROWS: 
            case WRITE_ROWS: {
                for (Serializable[] data : this.writeRowsData().getRows()) {
                    list.add(this.buildRowMap("insert", position, nextPosition, data, table, this.writeRowsData().getIncludedColumns(), rowQuery));
                }
                break;
            }
            case EXT_DELETE_ROWS: 
            case DELETE_ROWS: {
                for (Serializable[] data : this.deleteRowsData().getRows()) {
                    list.add(this.buildRowMap("delete", position, nextPosition, data, table, this.deleteRowsData().getIncludedColumns(), rowQuery));
                }
                break;
            }
            case EXT_UPDATE_ROWS: 
            case UPDATE_ROWS: {
                for (Map.Entry e : this.updateRowsData().getRows()) {
                    Serializable[] data = (Serializable[])e.getValue();
                    Serializable[] oldData = (Serializable[])e.getKey();
                    RowMap r = this.buildRowMap("update", position, nextPosition, data, table, this.updateRowsData().getIncludedColumns(), rowQuery);
                    this.writeOldData(table, r, oldData, this.updateRowsData().getIncludedColumnsBeforeUpdate());
                    list.add(r);
                }
                break;
            }
        }
        return list;
    }
}

