/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.replication;

import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.MariadbGtidSet;
import com.zendesk.maxwell.MaxwellMysqlStatus;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogPosition
implements Serializable {
    static final Logger LOGGER = LoggerFactory.getLogger(BinlogPosition.class);
    private static final String FILE_COLUMN = "File";
    private static final String POSITION_COLUMN = "Position";
    private static final String GTID_COLUMN = "Executed_Gtid_Set";
    private String gtidSetStr;
    private final String gtid;
    private final long offset;
    private final Long fileNumber;
    private final String file;

    public BinlogPosition(String gtidSetStr, String gtid, long l, String file) {
        this.gtidSetStr = gtidSetStr;
        this.gtid = gtid;
        this.offset = l;
        this.file = file;
        this.fileNumber = this.parseFileNumber(file);
    }

    public BinlogPosition(long l, String file) {
        this(null, null, l, file);
    }

    public static BinlogPosition capture(Connection c, boolean gtidMode) throws SQLException {
        MaxwellMysqlStatus m = new MaxwellMysqlStatus(c);
        try (Statement stmt = c.createStatement();){
            BinlogPosition binlogPosition;
            block13: {
                ResultSet rs = stmt.executeQuery("SHOW MASTER STATUS");
                try {
                    rs.next();
                    long l = rs.getInt(POSITION_COLUMN);
                    String file = rs.getString(FILE_COLUMN);
                    String gtidSetStr = null;
                    if (gtidMode) {
                        gtidSetStr = m.isMaria() ? m.getVariableState("gtid_binlog_state") : rs.getString(GTID_COLUMN);
                    }
                    binlogPosition = new BinlogPosition(gtidSetStr, null, l, file);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return binlogPosition;
        }
    }

    public static BinlogPosition at(BinlogPosition position) {
        return new BinlogPosition(position.gtidSetStr, position.gtid, position.offset, position.file);
    }

    public static BinlogPosition at(String gtidSetStr, long offset, String file) {
        return new BinlogPosition(gtidSetStr, null, offset, file);
    }

    public static BinlogPosition at(long offset, String file) {
        return new BinlogPosition(null, null, offset, file);
    }

    public long getOffset() {
        return this.offset;
    }

    public String getFile() {
        return this.file;
    }

    public String getGtid() {
        return this.gtid;
    }

    public String getGtidSetStr() {
        return this.gtidSetStr;
    }

    public BinlogPosition addGtid(String gtid, long offset, String file) {
        GtidSet set = this.getGtidSet();
        if (set == null) {
            return new BinlogPosition(offset, file);
        }
        set.add(gtid);
        return new BinlogPosition(set.toSeenString(), gtid, offset, file);
    }

    public void mergeGtids(GtidSet seenSet) {
        if (seenSet == null) {
            this.gtidSetStr = this.gtid;
        } else {
            seenSet.add(this.getGtid());
            this.gtidSetStr = seenSet.toSeenString();
        }
    }

    public GtidSet getGtidSet() {
        if (this.gtidSetStr == null) {
            return null;
        }
        if (MariadbGtidSet.isMariaGtidSet((String)this.gtidSetStr)) {
            return new MariadbGtidSet(this.gtidSetStr);
        }
        return new GtidSet(this.gtidSetStr);
    }

    public String toString() {
        return "BinlogPosition[" + (String)(this.gtidSetStr == null ? this.file + ":" + this.offset : this.gtidSetStr) + "]";
    }

    public String fullPosition() {
        String pos = this.file + ":" + this.offset;
        if (this.gtidSetStr != null) {
            pos = pos + "[" + this.gtidSetStr + "]";
        }
        return pos;
    }

    private Long parseFileNumber(String filename) {
        String[] split = filename.split("\\.");
        if (split.length < 2) {
            return null;
        }
        return Long.valueOf(split[split.length - 1]);
    }

    public Long getFileNumber() {
        return this.fileNumber;
    }

    public boolean newerThan(BinlogPosition other) {
        if (other == null) {
            return true;
        }
        if (this.gtidSetStr != null) {
            return !this.getGtidSet().isContainedWithin(other.getGtidSet());
        }
        long cmp = this.fileNumber == null || other.getFileNumber() == null ? (long)this.file.compareTo(other.file) : this.fileNumber - other.getFileNumber();
        if (cmp > 0L) {
            return true;
        }
        if (cmp == 0L) {
            return this.offset > other.offset;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BinlogPosition)) {
            return false;
        }
        BinlogPosition otherPosition = (BinlogPosition)other;
        return this.file.equals(otherPosition.file) && this.offset == otherPosition.offset && (this.gtidSetStr == null ? otherPosition.gtidSetStr == null : this.gtidSetStr.equals(otherPosition.gtidSetStr));
    }

    public int hashCode() {
        if (this.gtidSetStr != null) {
            return this.gtidSetStr.hashCode();
        }
        return Long.valueOf(this.offset).hashCode();
    }
}

