/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.replication;

import com.zendesk.maxwell.replication.BinlogPosition;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;

public class Position
implements Serializable {
    private final long lastHeartbeatRead;
    private final BinlogPosition binlogPosition;

    public Position(BinlogPosition binlogPosition, long lastHeartbeatRead) {
        this.binlogPosition = binlogPosition;
        this.lastHeartbeatRead = lastHeartbeatRead;
    }

    public static Position valueOf(BinlogPosition binlogPosition, Long lastHeartbeatRead) {
        return new Position(binlogPosition, lastHeartbeatRead);
    }

    public Position withHeartbeat(long lastHeartbeatRead) {
        return new Position(this.getBinlogPosition(), lastHeartbeatRead);
    }

    public static Position capture(Connection c, boolean gtidMode) throws SQLException {
        return new Position(BinlogPosition.capture(c, gtidMode), 0L);
    }

    public long getLastHeartbeatRead() {
        return this.lastHeartbeatRead;
    }

    public BinlogPosition getBinlogPosition() {
        return this.binlogPosition;
    }

    public Position addGtid(String gtid, long offset, String file) {
        return new Position(this.binlogPosition.addGtid(gtid, offset, file), this.lastHeartbeatRead);
    }

    public String toString() {
        return "Position[" + this.binlogPosition + ", lastHeartbeat=" + this.lastHeartbeatRead + "]";
    }

    public String toCommandline() {
        String gtid = this.binlogPosition.getGtidSetStr();
        if (gtid != null) {
            return gtid;
        }
        return this.binlogPosition.getFile() + ":" + this.binlogPosition.getOffset();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        return this.lastHeartbeatRead == other.lastHeartbeatRead && this.binlogPosition.equals(other.binlogPosition);
    }

    public int hashCode() {
        return this.binlogPosition.hashCode();
    }

    public boolean newerThan(Position other) {
        if (other == null) {
            return true;
        }
        return this.getBinlogPosition().newerThan(other.getBinlogPosition());
    }
}

