/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.zendesk.maxwell.row.DataJsonGenerator;
import com.zendesk.maxwell.row.EncryptionContext;
import com.zendesk.maxwell.row.RowEncrypt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;

class EncryptingJsonGenerator
implements DataJsonGenerator {
    private final JsonGenerator rawGenerator;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final JsonGenerator encryptedGenerator;

    public EncryptingJsonGenerator(JsonGenerator generator, JsonFactory jsonFactory) throws IOException {
        this.rawGenerator = generator;
        this.encryptedGenerator = jsonFactory.createGenerator((OutputStream)this.buffer);
    }

    @Override
    public JsonGenerator begin() throws IOException {
        return this.beginObject();
    }

    @Override
    public void end(EncryptionContext ctx) throws Exception {
        this.endObject(ctx);
    }

    private JsonGenerator beginObject() throws IOException {
        this.encryptedGenerator.writeStartObject();
        return this.encryptedGenerator;
    }

    private void endRaw(EncryptionContext ctx) throws Exception {
        this.encryptedGenerator.flush();
        String json = this.buffer.toString();
        this.buffer.reset();
        this.writeEncryptedField(json, ctx);
    }

    private void endObject(EncryptionContext ctx) throws Exception {
        this.encryptedGenerator.writeEndObject();
        this.endRaw(ctx);
    }

    public void writeEncryptedObject(String rawJson, EncryptionContext ctx) throws Exception {
        this.rawGenerator.writeStartObject();
        this.writeEncryptedField(rawJson, ctx);
        this.rawGenerator.writeEndObject();
    }

    private void writeEncryptedField(String rawJson, EncryptionContext ctx) throws Exception {
        String encryptedJSON = RowEncrypt.encrypt(rawJson, ctx.secretKey, ctx.iv);
        this.rawGenerator.writeObjectFieldStart("encrypted");
        this.rawGenerator.writeStringField("iv", Base64.encodeBase64String((byte[])ctx.iv));
        this.rawGenerator.writeStringField("bytes", encryptedJSON);
        this.rawGenerator.writeEndObject();
    }
}

