/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.fasterxml.jackson.core.JsonGenerator;
import com.zendesk.maxwell.errors.ProtectedAttributeNameException;
import com.zendesk.maxwell.producer.EncryptionMode;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.row.DataJsonGenerator;
import com.zendesk.maxwell.row.EncryptionContext;
import com.zendesk.maxwell.row.FieldNameStrategy;
import com.zendesk.maxwell.row.FieldNames;
import com.zendesk.maxwell.row.MaxwellJson;
import com.zendesk.maxwell.row.RowIdentity;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMap
implements Serializable {
    static final Logger LOGGER = LoggerFactory.getLogger(RowMap.class);
    private String rowQuery;
    private final String rowType;
    private final String database;
    private final String table;
    private final Long timestampMillis;
    private final Long timestampSeconds;
    private final Position position;
    private Position nextPosition;
    private String kafkaTopic;
    private String partitionString;
    protected boolean suppressed;
    private String comment;
    private Long xid;
    private Long xoffset;
    private boolean txCommit;
    private Long serverId;
    private Long threadId;
    private Long schemaId;
    private final LinkedHashMap<String, Object> data;
    private final LinkedHashMap<String, Object> oldData;
    private final LinkedHashMap<String, Object> extraAttributes;
    private final List<String> pkColumns;
    private RowIdentity rowIdentity;
    private long approximateSize;

    public RowMap(String type, String database, String table, Long timestampMillis, List<String> pkColumns, Position position, Position nextPosition, String rowQuery) {
        this.rowQuery = rowQuery;
        this.rowType = type;
        this.database = database;
        this.table = table;
        this.timestampMillis = timestampMillis;
        this.timestampSeconds = timestampMillis / 1000L;
        this.data = new LinkedHashMap();
        this.oldData = new LinkedHashMap();
        this.extraAttributes = new LinkedHashMap();
        this.position = position;
        this.nextPosition = nextPosition;
        this.pkColumns = pkColumns;
        this.suppressed = false;
        this.approximateSize = 100L;
    }

    public RowMap(String type, String database, String table, Long timestampMillis, List<String> pkColumns, Position nextPosition, String rowQuery) {
        this(type, database, table, timestampMillis, pkColumns, nextPosition, nextPosition, rowQuery);
    }

    public RowMap(String type, String database, String table, Long timestampMillis, List<String> pkColumns, Position nextPosition) {
        this(type, database, table, timestampMillis, pkColumns, nextPosition, null);
    }

    public RowIdentity getRowIdentity() {
        if (this.rowIdentity == null) {
            ArrayList<Pair<String, Object>> entries = new ArrayList<Pair<String, Object>>(this.pkColumns.size());
            for (String pk : this.pkColumns) {
                entries.add((Pair<String, Object>)Pair.of((Object)pk, (Object)this.data.get(pk)));
            }
            this.rowIdentity = new RowIdentity(this.database, this.table, this.rowType, entries);
        }
        return this.rowIdentity;
    }

    public String pkToJson(KeyFormat format) throws IOException {
        return this.getRowIdentity().toKeyJson(format);
    }

    public String buildPartitionKey(List<String> partitionColumns) {
        StringBuilder partitionKey = new StringBuilder();
        for (String pc : partitionColumns) {
            Object pcValue = null;
            if (this.data.containsKey(pc)) {
                pcValue = this.data.get(pc);
            }
            if (pcValue == null) continue;
            partitionKey.append(pcValue.toString());
        }
        return partitionKey.toString();
    }

    private void writeMapToJSON(FieldNameStrategy fieldNameStrategy, String jsonMapName, LinkedHashMap<String, Object> data, JsonGenerator g, boolean includeNullField) throws IOException, NoSuchAlgorithmException {
        g.writeObjectFieldStart(fieldNameStrategy.apply(jsonMapName));
        for (String key : data.keySet()) {
            Object value = data.get(key);
            MaxwellJson.writeValueToJSON(g, includeNullField, fieldNameStrategy.apply(key), value);
        }
        g.writeEndObject();
    }

    public String toJSON() throws Exception {
        return this.toJSON(new MaxwellOutputConfig());
    }

    public String toJSON(MaxwellOutputConfig outputConfig) throws Exception {
        FieldNameStrategy fieldNameStrategy = new FieldNameStrategy(outputConfig.namingStrategy);
        MaxwellJson json = MaxwellJson.getInstance();
        JsonGenerator g = json.reset();
        g.writeStartObject();
        g.writeStringField(fieldNameStrategy.apply("database"), this.database);
        g.writeStringField(fieldNameStrategy.apply("table"), this.table);
        if (outputConfig.includesRowQuery && this.rowQuery != null) {
            String outputQuery = outputConfig.rowQueryMaxLength > 0 && this.rowQuery.length() > outputConfig.rowQueryMaxLength ? this.rowQuery.substring(0, outputConfig.rowQueryMaxLength) : this.rowQuery;
            g.writeStringField(fieldNameStrategy.apply("query"), outputQuery);
        }
        g.writeStringField(fieldNameStrategy.apply("type"), this.rowType);
        g.writeNumberField(fieldNameStrategy.apply("ts"), this.timestampSeconds.longValue());
        if (outputConfig.includesCommitInfo) {
            if (this.xid != null) {
                g.writeNumberField(fieldNameStrategy.apply("xid"), this.xid.longValue());
            }
            if (outputConfig.includesXOffset && this.xoffset != null && !this.txCommit) {
                g.writeNumberField(fieldNameStrategy.apply("xoffset"), this.xoffset.longValue());
            }
            if (this.txCommit) {
                g.writeBooleanField(fieldNameStrategy.apply("commit"), true);
            }
        }
        if (this.position != null) {
            BinlogPosition binlogPosition = this.position.getBinlogPosition();
            if (outputConfig.includesBinlogPosition) {
                g.writeStringField(fieldNameStrategy.apply("position"), binlogPosition.getFile() + ":" + binlogPosition.getOffset());
            }
            if (outputConfig.includesGtidPosition) {
                g.writeStringField(fieldNameStrategy.apply("gtid"), binlogPosition.getGtid());
            }
        }
        if (outputConfig.includesServerId && this.serverId != null) {
            g.writeNumberField(fieldNameStrategy.apply("server_id"), this.serverId.longValue());
        }
        if (outputConfig.includesThreadId && this.threadId != null) {
            g.writeNumberField(fieldNameStrategy.apply("thread_id"), this.threadId.longValue());
        }
        if (outputConfig.includesSchemaId && this.schemaId != null) {
            g.writeNumberField(fieldNameStrategy.apply("schema_id"), this.schemaId.longValue());
        }
        if (outputConfig.includesPushTimestamp) {
            Instant pushTS = Instant.now().truncatedTo(ChronoUnit.MICROS);
            BigDecimal bigDecimal2 = BigDecimal.valueOf(pushTS.getEpochSecond());
            bigDecimal2 = bigDecimal2.add(BigDecimal.valueOf((double)pushTS.getNano() / 1.0E9));
            g.writeNumberField(fieldNameStrategy.apply("push_ts"), bigDecimal2);
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        for (Map.Entry entry : this.extraAttributes.entrySet()) {
            g.writeObjectField((String)entry.getKey(), entry.getValue());
        }
        EncryptionContext encryptionContext = null;
        if (outputConfig.encryptionEnabled()) {
            encryptionContext = EncryptionContext.create(outputConfig.secretKey);
        }
        DataJsonGenerator dataJsonGenerator = outputConfig.encryptionMode == EncryptionMode.ENCRYPT_DATA ? json.getEncryptingGenerator() : json.getPlaintextGenerator();
        JsonGenerator dataGenerator = dataJsonGenerator.begin();
        if (outputConfig.includesPrimaryKeys) {
            ArrayList pkValues = new ArrayList();
            this.pkColumns.forEach(pkColumn -> pkValues.add(this.data.get(pkColumn)));
            MaxwellJson.writeValueToJSON(g, outputConfig.includesNulls, fieldNameStrategy.apply("primary_key"), pkValues);
        }
        if (outputConfig.includesPrimaryKeyColumns) {
            MaxwellJson.writeValueToJSON(g, outputConfig.includesNulls, fieldNameStrategy.apply("primary_key_columns"), this.pkColumns);
        }
        if (outputConfig.excludeColumns.size() > 0) {
            HashSet<String> keys = new HashSet<String>();
            keys.addAll(this.data.keySet());
            keys.addAll(this.oldData.keySet());
            for (Pattern p : outputConfig.excludeColumns) {
                for (String key : keys) {
                    if (!p.matcher(key).matches()) continue;
                    this.data.remove(key);
                    this.oldData.remove(key);
                }
            }
        }
        this.writeMapToJSON(fieldNameStrategy, "data", this.data, dataGenerator, outputConfig.includesNulls);
        if (!this.oldData.isEmpty()) {
            this.writeMapToJSON(fieldNameStrategy, "old", this.oldData, dataGenerator, outputConfig.includesNulls);
        }
        dataJsonGenerator.end(encryptionContext);
        g.writeEndObject();
        if (outputConfig.encryptionMode == EncryptionMode.ENCRYPT_ALL) {
            String plaintext = json.consume();
            json.getEncryptingGenerator().writeEncryptedObject(plaintext, encryptionContext);
        }
        return json.consume();
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public Object getExtraAttribute(String key) {
        return this.extraAttributes.get(key);
    }

    public long getApproximateSize() {
        return this.approximateSize;
    }

    private long approximateKVSize(String key, Object value) {
        long length = 0L;
        length += 40L;
        length += (long)(key.length() * 2);
        length = value instanceof String ? (length += (long)(((String)value).length() * 2)) : (length += 64L);
        return length;
    }

    public void putData(String key, Object value) {
        this.data.put(key, value);
        this.approximateSize += this.approximateKVSize(key, value);
    }

    public void putExtraAttribute(String key, Object value) {
        if (FieldNames.isProtected(key)) {
            throw new ProtectedAttributeNameException("Extra attribute key name '" + key + "' is a protected name. Must not be any of: " + String.join((CharSequence)", ", FieldNames.getFieldnames()));
        }
        this.extraAttributes.put(key, value);
        this.approximateSize += this.approximateKVSize(key, value);
    }

    public Object getOldData(String key) {
        return this.oldData.get(key);
    }

    public void putOldData(String key, Object value) {
        this.oldData.put(key, value);
        this.approximateSize += this.approximateKVSize(key, value);
    }

    public Position getNextPosition() {
        return this.nextPosition;
    }

    public Position getPosition() {
        return this.position;
    }

    public Long getXid() {
        return this.xid;
    }

    public void setXid(Long xid) {
        this.xid = xid;
    }

    public Long getXoffset() {
        return this.xoffset;
    }

    public void setXoffset(Long xoffset) {
        this.xoffset = xoffset;
    }

    public void setTXCommit() {
        this.txCommit = true;
    }

    public boolean isTXCommit() {
        return this.txCommit;
    }

    public Long getServerId() {
        return this.serverId;
    }

    public void setServerId(Long serverId) {
        this.serverId = serverId;
    }

    public Long getThreadId() {
        return this.threadId;
    }

    public void setThreadId(Long threadId) {
        this.threadId = threadId;
    }

    public Long getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(Long schemaId) {
        this.schemaId = schemaId;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Long getTimestamp() {
        return this.timestampSeconds;
    }

    public Long getTimestampMillis() {
        return this.timestampMillis;
    }

    public boolean hasData(String name) {
        return this.data.containsKey(name);
    }

    public String getRowQuery() {
        return this.rowQuery;
    }

    public void setRowQuery(String query) {
        this.rowQuery = query;
    }

    public String getRowType() {
        return this.rowType;
    }

    public boolean shouldOutput(MaxwellOutputConfig outputConfig) {
        return !this.suppressed;
    }

    public LinkedHashMap<String, Object> getData() {
        return this.data;
    }

    public LinkedHashMap<String, Object> getExtraAttributes() {
        return this.extraAttributes;
    }

    public LinkedHashMap<String, Object> getOldData() {
        return this.oldData;
    }

    public void suppress() {
        this.suppressed = true;
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public void setKafkaTopic(String topic) {
        this.kafkaTopic = topic;
    }

    public String getPartitionString() {
        return this.partitionString;
    }

    public void setPartitionString(String partitionString) {
        this.partitionString = partitionString;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<String> getPrimaryKeyColumns() {
        return Collections.unmodifiableList(this.pkColumns);
    }

    public List<Object> getPrimaryKeyValues() {
        ArrayList values = new ArrayList();
        this.pkColumns.forEach(pkColumn -> values.add(this.data.get(pkColumn)));
        return Collections.unmodifiableList(values);
    }

    public Map<String, Object> getPrimaryKeyMap() {
        return this.pkColumns.stream().filter(v -> this.data.get(v) != null).collect(Collectors.toMap(k -> k, v -> this.data.get(v)));
    }

    public static enum KeyFormat {
        HASH,
        ARRAY;

    }
}

