/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.row.RowMapBuffer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class RowMapBufferByTable {
    private final long MAX_TX_ELEMENTS = 10000L;
    private HashMap<String, Buffer> buffers = new LinkedHashMap<String, Buffer>();

    public void add(RowMap row) throws IOException {
        this.getBuffer(row).add(row);
    }

    public RowMap removeFirst(String databaseName, String tableName) throws IOException, ClassNotFoundException {
        return this.getBuffer(databaseName, tableName).removeFirst();
    }

    public Long size(String databaseName, String tableName) throws IOException {
        return this.getBuffer(databaseName, tableName).size();
    }

    public void flushToDisk(String databaseName, String tableName) throws IOException {
        this.getBuffer(databaseName, tableName).flushToDisk();
    }

    private Buffer getBuffer(RowMap row) throws IOException {
        return this.getBuffer(this.getKey(row));
    }

    private Buffer getBuffer(String databaseName, String tableName) throws IOException {
        return this.getBuffer(this.getKey(databaseName, tableName));
    }

    private Buffer getBuffer(String key) throws IOException {
        Buffer buffer = this.buffers.get(key);
        if (buffer == null) {
            buffer = new Buffer();
            this.buffers.put(key, buffer);
        }
        return buffer;
    }

    private String getKey(RowMap row) {
        return this.getKey(row.getDatabase(), row.getTable());
    }

    private String getKey(String databaseName, String tableName) {
        return databaseName + " " + tableName;
    }

    private class Buffer
    extends RowMapBuffer {
        public Buffer() throws IOException {
            super(10000L);
        }
    }
}

