/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.zendesk.maxwell.MaxwellConfig;
import com.zendesk.maxwell.errors.DuplicateProcessException;
import com.zendesk.maxwell.recovery.RecoveryInfo;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.util.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlPositionStore {
    static final Logger LOGGER = LoggerFactory.getLogger(MysqlPositionStore.class);
    private static final Long DEFAULT_GTID_SERVER_ID = new Long(0L);
    private final Long serverID;
    private String clientID;
    private final boolean gtidMode;
    private final ConnectionPool connectionPool;
    private Long lastHeartbeat = null;

    public MysqlPositionStore(ConnectionPool pool, Long serverID, String clientID, boolean gtidMode) {
        this.connectionPool = pool;
        this.clientID = clientID;
        this.gtidMode = gtidMode;
        this.serverID = gtidMode ? DEFAULT_GTID_SERVER_ID : serverID;
    }

    public void set(Position newPosition) throws SQLException, DuplicateProcessException {
        if (newPosition == null) {
            return;
        }
        Long heartbeat = newPosition.getLastHeartbeatRead();
        String sql = "INSERT INTO `positions` set server_id = ?, gtid_set = ?, binlog_file = ?, binlog_position = ?, last_heartbeat_read = ?, client_id = ? ON DUPLICATE KEY UPDATE last_heartbeat_read = ?, gtid_set = ?, binlog_file = ?, binlog_position=?";
        BinlogPosition binlogPosition = newPosition.getBinlogPosition();
        this.connectionPool.withSQLRetry(1, c -> {
            try (PreparedStatement s = c.prepareStatement(sql);){
                LOGGER.debug("Writing binlog position to {}.positions: {}, last heartbeat read: {}", new Object[]{c.getCatalog(), newPosition, heartbeat});
                s.setLong(1, this.serverID);
                s.setString(2, binlogPosition.getGtidSetStr());
                s.setString(3, binlogPosition.getFile());
                s.setLong(4, binlogPosition.getOffset());
                s.setLong(5, heartbeat);
                s.setString(6, this.clientID);
                s.setLong(7, heartbeat);
                s.setString(8, binlogPosition.getGtidSetStr());
                s.setString(9, binlogPosition.getFile());
                s.setLong(10, binlogPosition.getOffset());
                s.execute();
            }
        });
    }

    public long heartbeat() throws Exception {
        long heartbeatValue = System.currentTimeMillis();
        this.heartbeat(heartbeatValue);
        return heartbeatValue;
    }

    public synchronized void heartbeat(long heartbeatValue) throws SQLException, DuplicateProcessException {
        this.connectionPool.withSQLRetry(1, c -> this.heartbeat((Connection)c, heartbeatValue));
    }

    private Long insertHeartbeat(Connection c, Long thisHeartbeat) throws SQLException, DuplicateProcessException {
        Long l;
        block8: {
            String heartbeatInsert = "insert into `heartbeats` set `heartbeat` = ?, `server_id` = ?, `client_id` = ?";
            PreparedStatement s = c.prepareStatement(heartbeatInsert);
            try {
                s.setLong(1, thisHeartbeat);
                s.setLong(2, this.serverID);
                s.setString(3, this.clientID);
                s.execute();
                l = thisHeartbeat;
                if (s == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLIntegrityConstraintViolationException e) {
                    throw new DuplicateProcessException("Found heartbeat row for client,position while trying to insert.  Is another maxwell running?");
                }
            }
            s.close();
        }
        return l;
    }

    private void heartbeat(Connection c, long thisHeartbeat) throws SQLException, DuplicateProcessException {
        int nRows;
        if (this.lastHeartbeat == null) {
            try (PreparedStatement s = c.prepareStatement("SELECT `heartbeat` from `heartbeats` where server_id = ? and client_id = ?");){
                s.setLong(1, this.serverID);
                s.setString(2, this.clientID);
                try (ResultSet rs = s.executeQuery();){
                    if (!rs.next()) {
                        this.insertHeartbeat(c, thisHeartbeat);
                        this.lastHeartbeat = thisHeartbeat;
                        return;
                    }
                    this.lastHeartbeat = rs.getLong("heartbeat");
                }
            }
        }
        String heartbeatUpdate = "update `heartbeats` set `heartbeat` = ? where `server_id` = ? and `client_id` = ? and `heartbeat` = ?";
        try (PreparedStatement s = c.prepareStatement(heartbeatUpdate);){
            s.setLong(1, thisHeartbeat);
            s.setLong(2, this.serverID);
            s.setString(3, this.clientID);
            s.setLong(4, this.lastHeartbeat);
            LOGGER.debug("writing heartbeat: {} (last heartbeat written: {})", (Object)thisHeartbeat, (Object)this.lastHeartbeat);
            nRows = s.executeUpdate();
        }
        if (nRows != 1) {
            String msg = String.format("Expected a heartbeat value of %d but didn't find it.  Is another Maxwell process running with the same client_id?", this.lastHeartbeat);
            throw new DuplicateProcessException(msg);
        }
        this.lastHeartbeat = thisHeartbeat;
    }

    public Long getLastHeartbeatSent() {
        return this.lastHeartbeat;
    }

    private Position positionFromResultSet(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        return MysqlPositionStore.positionFromResultSet(rs, this.gtidMode);
    }

    public static Position positionFromResultSet(ResultSet rs, boolean gtidMode) throws SQLException {
        String gtid = gtidMode ? rs.getString("gtid_set") : null;
        BinlogPosition pos = new BinlogPosition(gtid, null, rs.getLong("binlog_position"), rs.getString("binlog_file"));
        return new Position(pos, rs.getLong("last_heartbeat_read"));
    }

    /*
     * Exception decompiling
     */
    public Position getLatestFromAnyClient() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Position get() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public RecoveryInfo getRecoveryInfo(MaxwellConfig config) throws SQLException {
        try (Connection c = this.connectionPool.getConnection();){
            RecoveryInfo recoveryInfo = this.getRecoveryInfo(config, c);
            return recoveryInfo;
        }
    }

    protected RecoveryInfo getRecoveryInfo(MaxwellConfig config, Connection c) throws SQLException {
        List<RecoveryInfo> recoveries = this.getAllRecoveryInfos(c);
        if (recoveries.size() == 1) {
            return recoveries.get(0);
        }
        for (String line : this.formatRecoveryFailure(config, recoveries)) {
            LOGGER.error(line);
        }
        return null;
    }

    protected List<RecoveryInfo> getAllRecoveryInfos() throws SQLException {
        try (Connection c = this.connectionPool.getConnection();){
            List<RecoveryInfo> list = this.getAllRecoveryInfos(c);
            return list;
        }
    }

    protected List<RecoveryInfo> getAllRecoveryInfos(Connection c) throws SQLException {
        try (PreparedStatement s = c.prepareStatement("SELECT * from `positions` where client_id = ? order by last_heartbeat_read DESC");){
            ArrayList<RecoveryInfo> arrayList;
            block14: {
                s.setString(1, this.clientID);
                ResultSet rs = s.executeQuery();
                try {
                    ArrayList<RecoveryInfo> recoveries = new ArrayList<RecoveryInfo>();
                    while (rs.next()) {
                        Long server_id = rs.getLong("server_id");
                        String gtid = this.gtidMode ? rs.getString("gtid_set") : null;
                        Position position = new Position(BinlogPosition.at(gtid, rs.getLong("binlog_position"), rs.getString("binlog_file")), rs.getLong("last_heartbeat_read"));
                        if (rs.wasNull()) {
                            LOGGER.warn("master recovery is ignoring position with NULL heartbeat");
                            continue;
                        }
                        recoveries.add(new RecoveryInfo(position, server_id, this.clientID));
                    }
                    arrayList = recoveries;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
    }

    protected List<String> formatRecoveryFailure(MaxwellConfig config, List<RecoveryInfo> recoveries) {
        if (recoveries.size() == 0) {
            return Collections.singletonList("Unable to find any binlog positions in `positions` table");
        }
        ArrayList<String> result = new ArrayList<String>();
        Long mostRecentMaster = recoveries.get((int)0).serverID;
        result.add("Found multiple binlog positions for cluster in `positions` table.  Not attempting position recovery.");
        result.add("Positions found (most recent heartbeat first):");
        for (RecoveryInfo recovery : recoveries) {
            result.add(" - " + recovery);
        }
        result.add("Most likely the first is the most recent master, in which case you should:");
        result.add("1. stop maxwell");
        result.add("2. execute: DELETE FROM " + config.databaseName + ".positions WHERE server_id <> " + mostRecentMaster + " AND client_id = '<your_client_id>';");
        result.add("3. restart maxwell");
        return result;
    }

    public void cleanupOldRecoveryInfos() throws SQLException {
        List<RecoveryInfo> allRecoveryInfos = this.getAllRecoveryInfos();
        if (allRecoveryInfos.size() > 1) {
            LOGGER.warn("Multiple recovery infos found: " + allRecoveryInfos);
            LOGGER.info("Removing entries where server_id != " + this.serverID);
            try (Connection c = this.connectionPool.getConnection();
                 PreparedStatement s = c.prepareStatement("DELETE FROM `positions` WHERE server_id <> ? AND client_id = ?");){
                s.setLong(1, this.serverID);
                s.setString(2, this.clientID);
                s.execute();
            }
        }
    }
}

