/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.schema.MysqlSavedSchema;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaStoreSchema {
    static final Logger LOGGER = LoggerFactory.getLogger(SchemaStoreSchema.class);

    public static void ensureMaxwellSchema(Connection connection, String schemaDatabaseName) throws SQLException, IOException, InvalidSchemaError {
        if (!SchemaStoreSchema.storeDatabaseExists(connection, schemaDatabaseName)) {
            SchemaStoreSchema.createStoreDatabase(connection, schemaDatabaseName);
        }
    }

    private static boolean storeDatabaseExists(Connection connection, String schemaDatabaseName) throws SQLException {
        try (Statement s = connection.createStatement();){
            boolean bl;
            block21: {
                try (ResultSet rs = s.executeQuery("show databases like '" + schemaDatabaseName + "'");){
                    if (!rs.next()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                rs = s.executeQuery("show tables from `" + schemaDatabaseName + "` like 'schemas'");
                try {
                    bl = rs.next();
                    if (rs == null) break block21;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    private static void executeSQLInputStream(Connection connection, InputStream schemaSQL, String schemaDatabaseName) throws SQLException, IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader(schemaSQL));
        Object sql = "";
        if (schemaDatabaseName != null) {
            try (Statement stmt = connection.createStatement();){
                stmt.execute("CREATE DATABASE IF NOT EXISTS `" + schemaDatabaseName + "`");
            }
            if (!schemaDatabaseName.equals(connection.getCatalog())) {
                connection.setCatalog(schemaDatabaseName);
            }
        }
        while ((line = r.readLine()) != null) {
            sql = (String)sql + line + "\n";
        }
        for (String statement : StringUtils.splitByWholeSeparator((String)sql, (String)"\n\n")) {
            if (statement.length() == 0) continue;
            try (Statement stmt = connection.createStatement();){
                stmt.execute(statement);
            }
        }
    }

    private static void createStoreDatabase(Connection connection, String schemaDatabaseName) throws SQLException, IOException {
        LOGGER.info("Creating " + schemaDatabaseName + " database");
        SchemaStoreSchema.executeSQLInputStream(connection, SchemaStoreSchema.class.getResourceAsStream("/sql/maxwell_schema.sql"), schemaDatabaseName);
        SchemaStoreSchema.executeSQLInputStream(connection, SchemaStoreSchema.class.getResourceAsStream("/sql/maxwell_schema_bootstrap.sql"), schemaDatabaseName);
        SchemaStoreSchema.executeSQLInputStream(connection, SchemaStoreSchema.class.getResourceAsStream("/sql/maxwell_schema_heartbeats.sql"), schemaDatabaseName);
    }

    private static HashMap<String, String> getTableColumns(String table, Connection c) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (Statement stmt = c.createStatement();
             ResultSet rs = stmt.executeQuery("show columns from `" + table + "`");){
            while (rs.next()) {
                map.put(rs.getString("Field"), rs.getString("Type"));
            }
        }
        return map;
    }

    private static ArrayList<String> getMaxwellTables(Connection c) throws SQLException {
        ArrayList<String> l = new ArrayList<String>();
        try (Statement stmt = c.createStatement();
             ResultSet rs = stmt.executeQuery("show tables");){
            while (rs.next()) {
                l.add(rs.getString(1));
            }
        }
        return l;
    }

    private static void performAlter(Connection c, String sql) throws SQLException {
        LOGGER.info("Maxwell is upgrading its own schema: '" + sql + "'");
        try (Statement stmt = c.createStatement();){
            stmt.execute(sql);
        }
    }

    public static void upgradeSchemaStoreSchema(Connection c) throws SQLException, IOException {
        HashMap<String, String> schemaColumns2;
        HashMap<String, String> databasesColumns;
        HashMap<String, String> tablesColumns;
        HashMap<String, String> columnsColumns;
        HashMap<String, String> schemaColumns;
        ArrayList<String> maxwellTables = SchemaStoreSchema.getMaxwellTables(c);
        if (!SchemaStoreSchema.getTableColumns("schemas", c).containsKey("deleted")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column deleted tinyint(1) not null default 0");
        }
        if (!SchemaStoreSchema.getTableColumns("schemas", c).containsKey("gtid_set")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column gtid_set varchar(4096)");
        }
        if (!maxwellTables.contains("bootstrap")) {
            LOGGER.info("adding bootstrap tables to the maxwell schema.");
            InputStream is = MysqlSavedSchema.class.getResourceAsStream("/sql/maxwell_schema_bootstrap.sql");
            SchemaStoreSchema.executeSQLInputStream(c, is, null);
        }
        if (!SchemaStoreSchema.getTableColumns("bootstrap", c).containsKey("total_rows")) {
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` add column total_rows bigint unsigned not null default 0 after inserted_rows");
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` modify column inserted_rows bigint unsigned not null default 0");
        }
        if (!SchemaStoreSchema.getTableColumns("bootstrap", c).containsKey("where_clause")) {
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` add column where_clause varchar(1024)");
        }
        if (!(schemaColumns = SchemaStoreSchema.getTableColumns("schemas", c)).containsKey("charset")) {
            String[] charsetTables;
            for (String table : charsetTables = new String[]{"schemas", "databases", "tables", "columns"}) {
                SchemaStoreSchema.performAlter(c, "alter table `" + table + "` change `encoding` `charset` varchar(255)");
            }
        }
        if (!schemaColumns.containsKey("base_schema_id")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column base_schema_id int unsigned NULL default NULL after binlog_position");
        }
        if (!schemaColumns.containsKey("deltas")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column deltas mediumtext charset 'utf8' NULL default NULL after base_schema_id");
        }
        if (!schemaColumns.containsKey("version")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column `version` smallint unsigned not null default 0 after `charset`");
        }
        if (!SchemaStoreSchema.getTableColumns("positions", c).containsKey("client_id")) {
            SchemaStoreSchema.performAlter(c, "alter table `positions` add column `client_id` varchar(255) charset 'latin1' not null default 'maxwell'");
            SchemaStoreSchema.performAlter(c, "alter table `positions` drop primary key, add primary key(`server_id`, `client_id`)");
        }
        if (!SchemaStoreSchema.getTableColumns("positions", c).containsKey("gtid_set")) {
            SchemaStoreSchema.performAlter(c, "alter table `positions` add column gtid_set varchar(4096)");
        }
        if (!SchemaStoreSchema.getTableColumns("positions", c).containsKey("heartbeat_at")) {
            SchemaStoreSchema.performAlter(c, "alter table `positions` add column `heartbeat_at` bigint null default null");
        }
        if (!SchemaStoreSchema.getTableColumns("positions", c).containsKey("last_heartbeat_read")) {
            SchemaStoreSchema.performAlter(c, "alter table `positions` add column `last_heartbeat_read` bigint null default null");
        }
        if (!SchemaStoreSchema.getTableColumns("columns", c).containsKey("column_length")) {
            SchemaStoreSchema.performAlter(c, "alter table `columns` add column `column_length` tinyint unsigned");
        }
        if (!schemaColumns.containsKey("position_sha")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column `position_sha` char(40) charset 'latin1' null default null, add unique index(`position_sha`)");
            SchemaStoreSchema.backfillPositionSHAs(c);
        }
        if (!maxwellTables.contains("heartbeats")) {
            LOGGER.info("adding heartbeats table to the maxwell schema.");
            InputStream is = MysqlSavedSchema.class.getResourceAsStream("/sql/maxwell_schema_heartbeats.sql");
            SchemaStoreSchema.executeSQLInputStream(c, is, null);
        }
        if (!schemaColumns.containsKey("last_heartbeat_read")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` add column `last_heartbeat_read` bigint null default 0");
        }
        if (!SchemaStoreSchema.getTableColumns("bootstrap", c).containsKey("client_id")) {
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` add column `client_id` varchar(255) charset 'latin1' not null default 'maxwell'");
        }
        if (!SchemaStoreSchema.getTableColumns("bootstrap", c).containsKey("comment")) {
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` add column `comment` varchar(255) charset 'utf8' default null");
        }
        if (!SchemaStoreSchema.getTableColumns("bootstrap", c).get("where_clause").equals("text")) {
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` modify where_clause text default null");
        }
        if (!((columnsColumns = SchemaStoreSchema.getTableColumns("columns", c)).get("id").startsWith("bigint") && columnsColumns.get("schema_id").startsWith("bigint") && columnsColumns.get("table_id").startsWith("bigint"))) {
            SchemaStoreSchema.performAlter(c, "alter table `columns` modify id bigint NOT NULL AUTO_INCREMENT, modify schema_id bigint, modify table_id bigint");
        }
        if (!((tablesColumns = SchemaStoreSchema.getTableColumns("tables", c)).get("id").startsWith("bigint") && tablesColumns.get("schema_id").startsWith("bigint") && tablesColumns.get("database_id").startsWith("bigint"))) {
            SchemaStoreSchema.performAlter(c, "alter table `tables` modify id bigint NOT NULL AUTO_INCREMENT, modify schema_id bigint, modify database_id bigint");
        }
        if (!(databasesColumns = SchemaStoreSchema.getTableColumns("databases", c)).get("id").startsWith("bigint") || !databasesColumns.get("schema_id").startsWith("bigint")) {
            SchemaStoreSchema.performAlter(c, "alter table `databases` modify id bigint NOT NULL AUTO_INCREMENT, modify schema_id bigint");
        }
        if (!(schemaColumns2 = SchemaStoreSchema.getTableColumns("schemas", c)).get("id").startsWith("bigint") || !schemaColumns2.get("base_schema_id").startsWith("bigint")) {
            SchemaStoreSchema.performAlter(c, "alter table `schemas` modify id bigint NOT NULL AUTO_INCREMENT, modify base_schema_id bigint");
        }
        if (!SchemaStoreSchema.getTableColumns("bootstrap", c).get("id").startsWith("bigint")) {
            SchemaStoreSchema.performAlter(c, "alter table `bootstrap` modify id bigint NOT NULL AUTO_INCREMENT");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void backfillPositionSHAs(Connection c) throws SQLException {
        try (Statement stmt = c.createStatement();
             ResultSet rs = stmt.executeQuery("select * from `schemas`");){
            while (rs.next()) {
                Long id = rs.getLong("id");
                Position position = new Position(new BinlogPosition(rs.getLong("binlog_position"), rs.getString("binlog_file")), rs.getLong("last_heartbeat_read"));
                String sha = MysqlSavedSchema.getSchemaPositionSHA(rs.getLong("server_id"), position);
                Statement stmtUpdate = c.createStatement();
                try {
                    stmtUpdate.executeUpdate("update `schemas` set `position_sha` = '" + sha + "' where id = " + id);
                }
                finally {
                    if (stmtUpdate == null) continue;
                    stmtUpdate.close();
                }
            }
            return;
        }
    }
}

