/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.BigIntColumnDef;
import com.zendesk.maxwell.schema.columndef.BitColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import com.zendesk.maxwell.schema.columndef.ColumnDefDeserializer;
import com.zendesk.maxwell.schema.columndef.ColumnDefSerializer;
import com.zendesk.maxwell.schema.columndef.DateColumnDef;
import com.zendesk.maxwell.schema.columndef.DateTimeColumnDef;
import com.zendesk.maxwell.schema.columndef.DecimalColumnDef;
import com.zendesk.maxwell.schema.columndef.EnumColumnDef;
import com.zendesk.maxwell.schema.columndef.FloatColumnDef;
import com.zendesk.maxwell.schema.columndef.GeometryColumnDef;
import com.zendesk.maxwell.schema.columndef.IntColumnDef;
import com.zendesk.maxwell.schema.columndef.JsonColumnDef;
import com.zendesk.maxwell.schema.columndef.SetColumnDef;
import com.zendesk.maxwell.schema.columndef.StringColumnDef;
import com.zendesk.maxwell.schema.columndef.TimeColumnDef;
import com.zendesk.maxwell.schema.columndef.YearColumnDef;
import com.zendesk.maxwell.util.DynamicEnum;
import java.util.Objects;
import java.util.function.Consumer;

@JsonSerialize(using=ColumnDefSerializer.class)
@JsonDeserialize(using=ColumnDefDeserializer.class)
public abstract class ColumnDef
implements Cloneable {
    protected static final Interner INTERNER = Interners.newWeakInterner();
    private static final DynamicEnum dynamicEnum = new DynamicEnum(127L);
    private String name;
    private final byte type;
    private short pos;

    protected ColumnDef(String name, String type, short pos) {
        this.name = name;
        this.pos = pos;
        this.type = (byte)dynamicEnum.get(type);
    }

    public boolean equals(Object o) {
        if (o instanceof ColumnDef && o.getClass() == this.getClass()) {
            ColumnDef other = (ColumnDef)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.pos, other.pos) && Objects.equals(this.type, other.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.pos);
    }

    public abstract String toSQL(Object var1) throws ColumnDefCastException;

    protected <T extends ColumnDef> Interner<T> getInterner() {
        return INTERNER;
    }

    @Deprecated
    public Object asJSON(Object value) throws ColumnDefCastException {
        return this.asJSON(value, new MaxwellOutputConfig());
    }

    public Object asJSON(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        return value;
    }

    public ColumnDef clone() {
        try {
            return (ColumnDef)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static ColumnDef build(String name, String charset, String type, short pos, boolean signed, String[] enumValues, Long columnLength) {
        name = name.intern();
        if (charset != null) {
            charset = charset.intern();
        }
        switch (type) {
            case "tinyint": 
            case "smallint": 
            case "mediumint": 
            case "int": {
                return IntColumnDef.create(name, type, pos, signed);
            }
            case "bigint": {
                return BigIntColumnDef.create(name, type, pos, signed);
            }
            case "tinytext": 
            case "text": 
            case "mediumtext": 
            case "longtext": 
            case "varchar": 
            case "char": {
                return StringColumnDef.create(name, type, pos, charset);
            }
            case "tinyblob": 
            case "blob": 
            case "mediumblob": 
            case "longblob": 
            case "binary": 
            case "varbinary": {
                return StringColumnDef.create(name, type, pos, "binary");
            }
            case "geometry": 
            case "geometrycollection": 
            case "linestring": 
            case "multilinestring": 
            case "multipoint": 
            case "multipolygon": 
            case "polygon": 
            case "point": {
                return GeometryColumnDef.create(name, type, pos);
            }
            case "float": 
            case "double": {
                return FloatColumnDef.create(name, type, pos);
            }
            case "decimal": {
                return DecimalColumnDef.create(name, type, pos);
            }
            case "date": {
                return DateColumnDef.create(name, type, pos);
            }
            case "datetime": 
            case "timestamp": {
                return DateTimeColumnDef.create(name, type, pos, columnLength);
            }
            case "time": {
                return TimeColumnDef.create(name, type, pos, columnLength);
            }
            case "year": {
                return YearColumnDef.create(name, type, pos);
            }
            case "enum": {
                return EnumColumnDef.create(name, type, pos, enumValues);
            }
            case "set": {
                return SetColumnDef.create(name, type, pos, enumValues);
            }
            case "bit": {
                return BitColumnDef.create(name, type, pos);
            }
            case "json": {
                return JsonColumnDef.create(name, type, pos);
            }
        }
        throw new IllegalArgumentException("unsupported column type " + type);
    }

    private static String charToByteType(String type) {
        switch (type) {
            case "char": 
            case "character": {
                return "binary";
            }
            case "varchar": 
            case "varying": {
                return "varbinary";
            }
            case "tinytext": {
                return "tinyblob";
            }
            case "text": {
                return "blob";
            }
            case "mediumtext": {
                return "mediumblob";
            }
            case "longtext": {
                return "longblob";
            }
            case "long": {
                return "mediumblob";
            }
        }
        throw new RuntimeException("Unknown type with BYTE flag: " + type);
    }

    public static String unalias_type(String type, boolean longStringFlag, Long columnLength, boolean byteFlagToStringColumn) {
        if (byteFlagToStringColumn) {
            type = ColumnDef.charToByteType(type);
        }
        if (longStringFlag) {
            switch (type) {
                case "varchar": {
                    return "mediumtext";
                }
                case "varbinary": {
                    return "mediumblob";
                }
                case "binary": {
                    return "mediumtext";
                }
            }
        }
        switch (type) {
            case "character": 
            case "nchar": {
                return "char";
            }
            case "text": 
            case "blob": {
                if (columnLength == null) {
                    return type;
                }
                if (columnLength < 256L) {
                    return "tiny" + type;
                }
                if (columnLength < 65536L) {
                    return type;
                }
                if (columnLength < 0x1000000L) {
                    return "medium" + type;
                }
                return "long" + type;
            }
            case "nvarchar": 
            case "varying": {
                return "varchar";
            }
            case "bool": 
            case "boolean": 
            case "int1": {
                return "tinyint";
            }
            case "int2": {
                return "smallint";
            }
            case "int3": 
            case "middleint": {
                return "mediumint";
            }
            case "int4": 
            case "integer": {
                return "int";
            }
            case "int8": 
            case "serial": {
                return "bigint";
            }
            case "float4": {
                return "float";
            }
            case "real": 
            case "float8": {
                return "double";
            }
            case "numeric": 
            case "fixed": {
                return "decimal";
            }
            case "long": {
                return "mediumtext";
            }
        }
        return type;
    }

    public ColumnDef withName(String name) {
        return this.cloneSelfAndSet(clone -> {
            clone.name = name;
        });
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return dynamicEnum.get(this.type);
    }

    public int getPos() {
        return this.pos;
    }

    public ColumnDef withPos(short i) {
        if (this.pos == i) {
            return this;
        }
        return this.cloneSelfAndSet(clone -> {
            clone.pos = i;
        });
    }

    protected <T extends ColumnDef> T cloneSelfAndSet(Consumer<T> mutator) {
        ColumnDef clone = this.clone();
        mutator.accept(clone);
        return (T)((ColumnDef)this.getInterner().intern((Object)clone));
    }
}

