/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import java.util.Objects;

public abstract class ColumnDefWithLength
extends ColumnDef {
    private Long columnLength;
    protected static ThreadLocal<StringBuilder> threadLocalBuilder = new ThreadLocal<StringBuilder>(){

        @Override
        protected StringBuilder initialValue() {
            return new StringBuilder();
        }

        @Override
        public StringBuilder get() {
            StringBuilder b = (StringBuilder)super.get();
            b.setLength(0);
            return b;
        }
    };

    protected ColumnDefWithLength(String name, String type, short pos, Long columnLength) {
        super(name, type, pos);
        this.columnLength = columnLength == null ? Long.valueOf(0L) : columnLength;
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            ColumnDefWithLength other = (ColumnDefWithLength)o;
            return super.equals(o) && Objects.equals(this.columnLength, other.columnLength);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Objects.hash(this.columnLength);
    }

    @Override
    public String toSQL(Object value) throws ColumnDefCastException {
        return "'" + this.formatValue(value, new MaxwellOutputConfig()) + "'";
    }

    @Override
    public Object asJSON(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        return this.formatValue(value, config);
    }

    public Long getColumnLength() {
        return this.columnLength;
    }

    public ColumnDefWithLength withColumnLength(long length) {
        return this.cloneSelfAndSet(clone -> {
            clone.columnLength = length;
        });
    }

    protected abstract String formatValue(Object var1, MaxwellOutputConfig var2) throws ColumnDefCastException;

    protected static String appendFractionalSeconds(String value, int nanos, Long columnLength) {
        if (columnLength == 0L) {
            return value;
        }
        int divideBy = (int)Math.pow(10.0, 9L - columnLength);
        int fractional = nanos / divideBy;
        StringBuilder result = threadLocalBuilder.get();
        result.append(value);
        result.append(".");
        String asStr = String.valueOf(fractional);
        int i = 0;
        while ((long)i < columnLength - (long)asStr.length()) {
            result.append("0");
            ++i;
        }
        result.append(asStr);
        return result.toString();
    }
}

