/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import java.util.List;
import java.util.Objects;

public abstract class EnumeratedColumnDef
extends ColumnDef {
    @JsonProperty(value="enum-values")
    private final List<String> enumValues;

    protected EnumeratedColumnDef(String name, String type, short pos, String[] enumValues) {
        super(name, type, pos);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)enumValues.length);
        for (String enumValue : enumValues) {
            builder.add((Object)enumValue.intern());
        }
        this.enumValues = builder.build();
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            EnumeratedColumnDef other = (EnumeratedColumnDef)o;
            return super.equals(o) && Objects.equals(this.enumValues, other.enumValues);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Objects.hash(this.enumValues);
    }
}

