/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import com.zendesk.maxwell.schema.columndef.EnumeratedColumnDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SetColumnDef
extends EnumeratedColumnDef {
    private SetColumnDef(String name, String type, short pos, String[] enumValues) {
        super(name, type, pos, enumValues);
    }

    public static SetColumnDef create(String name, String type, short pos, String[] enumValues) {
        SetColumnDef temp = new SetColumnDef(name, type, pos, enumValues);
        return (SetColumnDef)INTERNER.intern((Object)temp);
    }

    @Override
    public String toSQL(Object value) throws ColumnDefCastException {
        return "'" + StringUtils.join(this.asList(value), (String)"'") + "'";
    }

    @Override
    public Object asJSON(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        return this.asList(value);
    }

    private ArrayList<String> asList(Object value) throws ColumnDefCastException {
        if (value instanceof String) {
            return new ArrayList<String>(Arrays.asList(((String)value).split(",")));
        }
        if (value instanceof Long) {
            ArrayList<String> values = new ArrayList<String>();
            long v = (Long)value;
            List<String> enumValues = this.getEnumValues();
            for (int i = 0; i < enumValues.size(); ++i) {
                if ((v >> i & 1L) != 1L) continue;
                values.add(enumValues.get(i));
            }
            return values;
        }
        throw new ColumnDefCastException(this, value);
    }
}

