/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class StringColumnDef
extends ColumnDef {
    private String charset;

    private StringColumnDef(String name, String type, short pos, String charset) {
        super(name, type, pos);
        this.charset = charset;
    }

    public static StringColumnDef create(String name, String type, short pos, String charset) {
        StringColumnDef temp = new StringColumnDef(name, type, pos, charset);
        return (StringColumnDef)INTERNER.intern((Object)temp);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() == this.getClass()) {
            StringColumnDef other = (StringColumnDef)o;
            return super.equals(other) && Objects.equals(this.charset, other.charset);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 31 * hash + Objects.hash(this.charset);
    }

    public String getCharset() {
        return this.charset;
    }

    public StringColumnDef withCharset(String charset) {
        return this.cloneSelfAndSet(clone -> {
            clone.charset = charset;
        });
    }

    public StringColumnDef withDefaultCharset(String charset) {
        if (this.charset == null) {
            return this.cloneSelfAndSet(clone -> {
                clone.charset = charset;
            });
        }
        return this;
    }

    @Override
    public String toSQL(Object value) {
        byte[] b = (byte[])value;
        if (this.charset.equals("utf8") || this.charset.equals("utf8mb4")) {
            return this.quoteString(new String(b));
        }
        return "x'" + Hex.encodeHexString((byte[])b) + "'";
    }

    private Charset charsetForCharset() {
        switch (this.charset.toLowerCase()) {
            case "utf8": 
            case "utf8mb3": 
            case "utf8mb4": {
                return StandardCharsets.UTF_8;
            }
            case "latin1": 
            case "ascii": {
                return Charset.forName("Windows-1252");
            }
            case "ucs2": {
                return StandardCharsets.UTF_16;
            }
            case "ujis": {
                return Charset.forName("EUC-JP");
            }
        }
        try {
            return Charset.forName(this.charset.toLowerCase());
        }
        catch (UnsupportedCharsetException e) {
            throw new RuntimeException("error: unhandled character set '" + this.charset + "'");
        }
    }

    @Override
    public Object asJSON(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof byte[]) {
            byte[] b = (byte[])value;
            if (this.charset.equals("binary")) {
                return Base64.encodeBase64String((byte[])b);
            }
            return new String(b, this.charsetForCharset());
        }
        throw new ColumnDefCastException(this, value);
    }

    private String quoteString(String s) {
        String escaped = s.replaceAll("'", "''");
        escaped = escaped.replaceAll("\n", "\\\\n");
        escaped = escaped.replaceAll("\r", "\\\\r");
        return "'" + escaped + "'";
    }
}

