/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

public class DDLMap
extends RowMap {
    private final ResolvedSchemaChange change;
    private final Long timestamp;
    private final String sql;
    private Position position;
    private final Long schemaId;

    public DDLMap(ResolvedSchemaChange change, Long timestamp, String sql, Position position, Position nextPosition, Long schemaId) {
        super("ddl", change.databaseName(), change.tableName(), timestamp, new ArrayList<String>(0), position, nextPosition, sql);
        this.change = change;
        this.timestamp = timestamp;
        this.sql = sql;
        this.position = position;
        this.schemaId = schemaId;
    }

    @Override
    public String pkToJson(RowMap.KeyFormat keyFormat) throws IOException {
        return UUID.randomUUID().toString();
    }

    @Override
    public boolean isTXCommit() {
        return false;
    }

    @Override
    public String toJSON() throws IOException {
        return this.toJSON(new MaxwellOutputConfig());
    }

    public Map<String, Object> getChangeMap() {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.convertValue((Object)this.change, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public String toJSON(MaxwellOutputConfig outputConfig) throws IOException {
        if (!outputConfig.outputDDL) {
            return null;
        }
        Map<String, Object> map = this.getChangeMap();
        map.put("ts", this.timestamp);
        map.put("sql", this.sql);
        map.putAll(this.getExtraAttributes());
        BinlogPosition binlogPosition = this.position.getBinlogPosition();
        if (outputConfig.includesBinlogPosition) {
            map.put("position", binlogPosition.getFile() + ":" + binlogPosition.getOffset());
        }
        if (outputConfig.includesGtidPosition) {
            map.put("gtid", binlogPosition.getGtid());
        }
        if (outputConfig.includesSchemaId) {
            map.put("schema_id", this.schemaId);
        }
        return new ObjectMapper().writeValueAsString(map);
    }

    @Override
    public boolean shouldOutput(MaxwellOutputConfig outputConfig) {
        return outputConfig.outputDDL && !this.suppressed;
    }

    public String getSql() {
        return this.sql;
    }
}

