/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedDatabaseDrop;
import com.zendesk.maxwell.schema.ddl.SchemaChange;

public class DatabaseDrop
extends SchemaChange {
    public String database;
    public boolean ifExists;

    public DatabaseDrop(String database, boolean ifExists) {
        this.database = database;
        this.ifExists = ifExists;
    }

    @Override
    public ResolvedDatabaseDrop resolve(Schema schema) throws InvalidSchemaError {
        if (this.ifExists && !schema.hasDatabase(this.database)) {
            return null;
        }
        return new ResolvedDatabaseDrop(this.database);
    }

    @Override
    public boolean isBlacklisted(Filter filter) {
        if (filter == null) {
            return false;
        }
        return filter.isDatabaseBlacklisted(this.database);
    }
}

