/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.ddl.AddColumnMod;
import com.zendesk.maxwell.schema.ddl.ChangeColumnMod;
import com.zendesk.maxwell.schema.ddl.ColumnPosition;
import com.zendesk.maxwell.schema.ddl.DatabaseAlter;
import com.zendesk.maxwell.schema.ddl.DatabaseCreate;
import com.zendesk.maxwell.schema.ddl.DatabaseDrop;
import com.zendesk.maxwell.schema.ddl.MaxwellSQLSyntaxError;
import com.zendesk.maxwell.schema.ddl.RemoveColumnMod;
import com.zendesk.maxwell.schema.ddl.RenameColumnMod;
import com.zendesk.maxwell.schema.ddl.ReparseSQLException;
import com.zendesk.maxwell.schema.ddl.SchemaChange;
import com.zendesk.maxwell.schema.ddl.TableAlter;
import com.zendesk.maxwell.schema.ddl.TableCreate;
import com.zendesk.maxwell.schema.ddl.TableDrop;
import com.zendesk.maxwell.schema.ddl.mysqlBaseListener;
import com.zendesk.maxwell.schema.ddl.mysqlParser;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlParserListener
extends mysqlBaseListener {
    final Logger LOGGER = LoggerFactory.getLogger(MysqlParserListener.class);
    private String tableName;
    private final ArrayList<SchemaChange> schemaChanges;
    private final String currentDatabase;
    private final TokenStream tokenStream;
    private ColumnPosition columnPosition;
    private final LinkedList<ColumnDef> columnDefs = new LinkedList();
    private ArrayList<String> pkColumns = null;

    public List<SchemaChange> getSchemaChanges() {
        return this.schemaChanges;
    }

    MysqlParserListener(String currentDatabase, TokenStream tokenStream) {
        this.schemaChanges = new ArrayList();
        this.currentDatabase = currentDatabase;
        this.tokenStream = tokenStream;
    }

    private String unquote(String ident) {
        if (ident.startsWith("`") || ident.startsWith("\"")) {
            return ident.substring(1, ident.length() - 1);
        }
        return ident;
    }

    private String unquote_literal(String ident) {
        return this.unquote(ident.replaceAll("^'", "").replaceAll("'$", ""));
    }

    private String getDB(mysqlParser.Table_nameContext t) {
        if (t.db_name() != null) {
            return this.unquote(t.db_name().getText());
        }
        return this.currentDatabase;
    }

    private String getTable(mysqlParser.Table_nameContext t) {
        String name = t.name() != null ? t.name().getText() : t.name_all_tokens().getText();
        return this.unquote(name);
    }

    private TableAlter alterStatement() {
        return (TableAlter)this.schemaChanges.get(0);
    }

    private String getCharset(List<mysqlParser.Column_optionsContext> list) {
        for (mysqlParser.Column_optionsContext ctx : list) {
            if (ctx.charset_def() == null) continue;
            if (ctx.charset_def().ASCII() != null) {
                return "latin1";
            }
            return this.unquote_literal(ctx.charset_def().character_set().charset_name().getText());
        }
        return null;
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        this.schemaChanges.clear();
        String error = node.getParent().toStringTree((Parser)new mysqlParser(null));
        this.LOGGER.error(error);
        throw new MaxwellSQLSyntaxError(node.getText());
    }

    private boolean isSigned(List<mysqlParser.Int_flagsContext> flags) {
        for (mysqlParser.Int_flagsContext flag : flags) {
            if (flag.UNSIGNED() == null) continue;
            return false;
        }
        return true;
    }

    private ColumnPosition getColumnPosition() {
        ColumnPosition p = this.columnPosition;
        this.columnPosition = null;
        if (p == null) {
            return new ColumnPosition();
        }
        return p;
    }

    @Override
    public void exitAlter_database(mysqlParser.Alter_databaseContext ctx) {
        String dbName = ctx.name() != null ? ctx.name().getText() : this.currentDatabase;
        dbName = this.unquote(dbName);
        DatabaseAlter alter = new DatabaseAlter(dbName);
        List<mysqlParser.Default_character_setContext> charSet = ctx.alter_database_definition().default_character_set();
        if (charSet.size() > 0) {
            alter.charset = this.unquote_literal(charSet.get(0).charset_name().getText());
        }
        this.schemaChanges.add(alter);
    }

    @Override
    public void exitAlter_table_preamble(mysqlParser.Alter_table_preambleContext ctx) {
        String dbName = this.getDB(ctx.table_name());
        String tableName = this.getTable(ctx.table_name());
        TableAlter alterStatement = new TableAlter(dbName, tableName);
        this.tableName = alterStatement.table;
        this.schemaChanges.add(alterStatement);
    }

    @Override
    public void exitAlter_table(mysqlParser.Alter_tableContext ctx) {
        this.alterStatement().pks = this.pkColumns;
    }

    @Override
    public void enterAlter_view(mysqlParser.Alter_viewContext ctx) {
        throw new ParseCancellationException("Not finishing parse of ALTER VIEW");
    }

    @Override
    public void enterCreate_view(mysqlParser.Create_viewContext ctx) {
        throw new ParseCancellationException("Not finishing parse of CREATE VIEW");
    }

    @Override
    public void exitAdd_column(mysqlParser.Add_columnContext ctx) {
        ColumnDef c = this.columnDefs.removeFirst();
        this.alterStatement().columnMods.add(new AddColumnMod(c.getName(), c, this.getColumnPosition()));
    }

    @Override
    public void exitAdd_column_parens(mysqlParser.Add_column_parensContext ctx) {
        while (this.columnDefs.size() > 0) {
            ColumnDef c = this.columnDefs.removeFirst();
            this.alterStatement().columnMods.add(new AddColumnMod(c.getName(), c, new ColumnPosition()));
        }
    }

    @Override
    public void exitChange_column(mysqlParser.Change_columnContext ctx) {
        String oldColumnName = this.unquote(ctx.full_column_name().col_name.getText());
        ColumnDef c = this.columnDefs.removeFirst();
        this.alterStatement().columnMods.add(new ChangeColumnMod(oldColumnName, c, this.getColumnPosition()));
    }

    @Override
    public void exitModify_column(mysqlParser.Modify_columnContext ctx) {
        ColumnDef c = this.columnDefs.removeFirst();
        this.alterStatement().columnMods.add(new ChangeColumnMod(c.getName(), c, this.getColumnPosition()));
    }

    @Override
    public void exitRename_column(mysqlParser.Rename_columnContext ctx) {
        String oldName = this.unquote(ctx.name(0).getText());
        String newName = this.unquote(ctx.name(1).getText());
        this.alterStatement().columnMods.add(new RenameColumnMod(oldName, newName));
    }

    @Override
    public void exitDrop_column(mysqlParser.Drop_columnContext ctx) {
        String colName = ctx.full_column_name().col_name.getText();
        this.alterStatement().columnMods.add(new RemoveColumnMod(this.unquote(colName), ctx.if_exists() != null));
    }

    @Override
    public void exitCol_position(mysqlParser.Col_positionContext ctx) {
        this.columnPosition = new ColumnPosition();
        if (ctx.FIRST() != null) {
            this.columnPosition.position = ColumnPosition.Position.FIRST;
        } else if (ctx.AFTER() != null) {
            this.columnPosition.position = ColumnPosition.Position.AFTER;
            this.columnPosition.afterColumn = this.unquote(ctx.name().getText());
        }
    }

    @Override
    public void exitAlter_rename_table(mysqlParser.Alter_rename_tableContext ctx) {
        this.alterStatement().newTableName = this.getTable(ctx.table_name());
        this.alterStatement().newDatabase = this.getDB(ctx.table_name());
    }

    @Override
    public void exitConvert_to_character_set(mysqlParser.Convert_to_character_setContext ctx) {
        this.alterStatement().convertCharset = this.unquote_literal(ctx.charset_name().getText());
    }

    @Override
    public void exitDefault_character_set(mysqlParser.Default_character_setContext ctx) {
        if (ctx.parent instanceof mysqlParser.Alter_specificationContext) {
            this.alterStatement().defaultCharset = this.unquote_literal(ctx.charset_name().getText());
        }
    }

    @Override
    public void exitCreate_table_preamble(mysqlParser.Create_table_preambleContext ctx) {
        String dbName = this.getDB(ctx.table_name());
        String tblName = this.getTable(ctx.table_name());
        boolean ifNotExists = ctx.if_not_exists() != null;
        TableCreate createStatement = new TableCreate(dbName, tblName, ifNotExists);
        this.tableName = createStatement.table;
        this.schemaChanges.add(createStatement);
    }

    @Override
    public void exitCreate_like_tbl(mysqlParser.Create_like_tblContext ctx) {
        TableCreate tableCreate = (TableCreate)this.schemaChanges.get(0);
        tableCreate.likeDB = this.getDB(ctx.table_name());
        tableCreate.likeTable = this.getTable(ctx.table_name());
    }

    @Override
    public void exitCreate_specifications(mysqlParser.Create_specificationsContext ctx) {
        TableCreate tableCreate = (TableCreate)this.schemaChanges.get(0);
        tableCreate.columns.addAll(this.columnDefs);
        tableCreate.pks = this.pkColumns;
    }

    @Override
    public void exitCreation_character_set(mysqlParser.Creation_character_setContext ctx) {
        SchemaChange change = this.schemaChanges.get(0);
        if (change instanceof TableCreate) {
            TableCreate tableCreate = (TableCreate)change;
            tableCreate.charset = this.unquote_literal(ctx.charset_name().getText());
        } else if (change instanceof TableAlter) {
            ((TableAlter)change).defaultCharset = this.unquote_literal(ctx.charset_name().getText());
        }
    }

    @Override
    public void exitDrop_table(mysqlParser.Drop_tableContext ctx) {
        boolean ifExists = ctx.if_exists() != null;
        for (mysqlParser.Table_nameContext t : ctx.table_name()) {
            this.schemaChanges.add(new TableDrop(this.getDB(t), this.getTable(t), ifExists));
        }
    }

    @Override
    public void exitDrop_database(mysqlParser.Drop_databaseContext ctx) {
        boolean ifExists = ctx.if_exists() != null;
        String dbName = this.unquote(ctx.name().getText());
        this.schemaChanges.add(new DatabaseDrop(dbName, ifExists));
    }

    private String spliceParens(int startIndex, int initialParenCount) {
        int i;
        TokenStreamRewriter r = new TokenStreamRewriter(this.tokenStream);
        int parens = initialParenCount;
        for (i = startIndex; i < this.tokenStream.size(); ++i) {
            String tokenText = this.tokenStream.get(i).getText();
            if (tokenText.equals("(")) {
                ++parens;
            } else if (tokenText.equals(")")) {
                --parens;
            }
            if (parens == 0) break;
        }
        r.insertBefore(startIndex, (Object)"/__MAXWELL__/");
        r.delete(startIndex, i);
        return r.getText();
    }

    @Override
    public void enterSkip_parens(mysqlParser.Skip_parensContext ctx) {
        if (ctx.MAXWELL_ELIDED_PARSE_ISSUE() == null) {
            throw new ReparseSQLException(this.spliceParens(ctx.getStart().getTokenIndex(), 0));
        }
    }

    @Override
    public void enterSkip_parens_inside_partition_definitions(mysqlParser.Skip_parens_inside_partition_definitionsContext ctx) {
        if (ctx.MAXWELL_ELIDED_PARSE_ISSUE() == null) {
            throw new ReparseSQLException(this.spliceParens(ctx.getStart().getTokenIndex(), 1));
        }
    }

    @Override
    public void exitIndex_type_pk(mysqlParser.Index_type_pkContext ctx) {
        this.pkColumns = new ArrayList();
        for (mysqlParser.Index_columnContext column : ctx.index_column_list().index_columns().index_column()) {
            mysqlParser.NameContext n = column.name();
            this.pkColumns.add(this.unquote(n.getText()));
        }
    }

    @Override
    public void exitDrop_primary_key(mysqlParser.Drop_primary_keyContext ctx) {
        this.pkColumns = new ArrayList();
    }

    private Long extractColumnLength(mysqlParser.LengthContext l) {
        if (l == null) {
            return null;
        }
        return Long.valueOf(l.INTEGER_LITERAL().getText());
    }

    @Override
    public void exitColumn_definition(mysqlParser.Column_definitionContext ctx) {
        Long columnLength = null;
        Boolean longStringFlag = false;
        String colType = null;
        String colCharset = null;
        String[] enumValues = null;
        List<mysqlParser.Column_optionsContext> colOptions = null;
        boolean signed = true;
        boolean byteFlagToStringColumn = false;
        String name = this.unquote(ctx.col_name.getText());
        mysqlParser.Data_typeContext dctx = ctx.data_type();
        if (dctx.generic_type() != null) {
            colType = dctx.generic_type().col_type.getText();
            colOptions = dctx.generic_type().column_options();
            columnLength = this.extractColumnLength(dctx.generic_type().length());
        } else if (dctx.signed_type() != null) {
            colType = dctx.signed_type().col_type.getText();
            signed = this.isSigned(dctx.signed_type().int_flags());
            colOptions = dctx.signed_type().column_options();
            if (colType.toLowerCase().equals("serial")) {
                signed = false;
            }
        } else if (dctx.string_type() != null) {
            colType = dctx.string_type().col_type.getText();
            colCharset = this.getCharset(dctx.string_type().column_options());
            if (dctx.string_type().utf8.booleanValue()) {
                colCharset = "utf8";
            }
            if (dctx.string_type().BYTE().size() > 0) {
                byteFlagToStringColumn = true;
            }
            if (dctx.string_type().UNICODE().size() > 0) {
                colCharset = "ucs2";
            }
            columnLength = this.extractColumnLength(dctx.string_type().length());
            colOptions = dctx.string_type().column_options();
            longStringFlag = dctx.string_type().long_flag() != null;
        } else if (dctx.enumerated_type() != null) {
            List<mysqlParser.Enum_valueContext> valueList = dctx.enumerated_type().enumerated_values().enum_value();
            colType = dctx.enumerated_type().col_type.getText();
            colCharset = this.getCharset(dctx.enumerated_type().column_options());
            colOptions = dctx.enumerated_type().column_options();
            enumValues = new String[valueList.size()];
            int i = 0;
            for (mysqlParser.Enum_valueContext v : valueList) {
                enumValues[i++] = this.unquote_literal(v.getText());
            }
        }
        colType = ColumnDef.unalias_type(colType.toLowerCase(), longStringFlag, columnLength, byteFlagToStringColumn);
        ColumnDef c = ColumnDef.build(name, colCharset, colType.toLowerCase(), (short)-1, signed, enumValues, columnLength);
        this.columnDefs.add(c);
        if (colOptions != null) {
            for (mysqlParser.Column_optionsContext opt : colOptions) {
                if (opt.primary_key() == null) continue;
                this.pkColumns = new ArrayList();
                this.pkColumns.add(name);
            }
        }
    }

    @Override
    public void exitRename_table_spec(mysqlParser.Rename_table_specContext ctx) {
        mysqlParser.Table_nameContext oldTableContext = ctx.table_name(0);
        mysqlParser.Table_nameContext newTableContext = ctx.table_name(1);
        TableAlter t = new TableAlter(this.getDB(oldTableContext), this.getTable(oldTableContext));
        t.newDatabase = this.getDB(newTableContext);
        t.newTableName = this.getTable(newTableContext);
        this.schemaChanges.add(t);
    }

    @Override
    public void exitCreate_database(mysqlParser.Create_databaseContext ctx) {
        String dbName = this.unquote(ctx.name().getText());
        boolean ifNotExists = ctx.if_not_exists() != null;
        String charset = null;
        for (mysqlParser.Create_optionContext option : ctx.create_option()) {
            if (option.default_character_set() == null) continue;
            charset = this.unquote_literal(option.default_character_set().charset_name().getText());
        }
        this.schemaChanges.add(new DatabaseCreate(dbName, ifNotExists, charset));
    }
}

