/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;

public class ResolvedDatabaseAlter
extends ResolvedSchemaChange {
    public String database;
    public String charset;

    public ResolvedDatabaseAlter() {
    }

    public ResolvedDatabaseAlter(String database, String charset) {
        this.database = database;
        this.charset = charset;
    }

    @Override
    public void apply(Schema schema) throws InvalidSchemaError {
        if (this.charset == null) {
            return;
        }
        Database d = schema.findDatabaseOrThrow(this.database);
        if (!d.getCharset().equals(this.charset)) {
            d.setCharset(this.charset);
        }
    }

    @Override
    public String databaseName() {
        return this.database;
    }

    @Override
    public String tableName() {
        return null;
    }
}

