/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.MaxwellSQLSyntaxError;
import com.zendesk.maxwell.schema.ddl.MysqlParserListener;
import com.zendesk.maxwell.schema.ddl.ReparseSQLException;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;
import com.zendesk.maxwell.schema.ddl.mysqlLexer;
import com.zendesk.maxwell.schema.ddl.mysqlParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchemaChange {
    static final Logger LOGGER = LoggerFactory.getLogger(SchemaChange.class);
    private static final Set<Pattern> SQL_BLACKLIST = new HashSet<Pattern>();
    private static final Pattern SET_STATEMENT = Pattern.compile("SET\\s+STATEMENT\\s+(\\w+\\s*=\\s*((?<quote>['\"]).*?\\k<quote>|\\w+),?\\s*)+FOR\\s+", 10);
    private static final Pattern DELETE_BLACKLIST;
    private static final Pattern CSTYLE_COMMENTS;

    public abstract ResolvedSchemaChange resolve(Schema var1) throws InvalidSchemaError;

    private static boolean matchesBlacklist(String sql) {
        sql = sql.replaceAll("/\\*M?!\\d+\\s*(.*)\\*/", "$1");
        sql = CSTYLE_COMMENTS.matcher(sql).replaceAll("");
        sql = sql.replaceAll("\\-\\-.*", "");
        sql = Pattern.compile("^\\s*#.*", 8).matcher(sql).replaceAll("");
        sql = SET_STATEMENT.matcher(sql).replaceAll("");
        for (Pattern p : SQL_BLACKLIST) {
            if (!p.matcher(sql).find()) continue;
            LOGGER.debug("ignoring sql: {}", (Object)sql);
            return true;
        }
        if (DELETE_BLACKLIST.matcher(sql).find()) {
            LOGGER.info("Ignoring DELETE statement: " + sql);
            LOGGER.info("You may ignore this warning if this is a MEMORY table.");
            LOGGER.info("Otherwise you should make sure your binlog_format setting is correct, and that your clients have all reconnected.");
            return true;
        }
        return false;
    }

    private static List<SchemaChange> parseSQL(String currentDB, String sql) {
        ANTLRInputStream input = new ANTLRInputStream(sql);
        mysqlLexer lexer = new mysqlLexer((CharStream)input);
        lexer.removeErrorListeners();
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        LOGGER.debug("SQL_PARSE <- \"{}\"", (Object)sql);
        mysqlParser parser = new mysqlParser((TokenStream)tokens);
        parser.removeErrorListeners();
        MysqlParserListener listener = new MysqlParserListener(currentDB, (TokenStream)tokens);
        mysqlParser.ParseContext tree = parser.parse();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)listener, (ParseTree)tree);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SQL_PARSE ->   {}", (Object)tree.toStringTree(parser));
        }
        return listener.getSchemaChanges();
    }

    public static List<SchemaChange> parse(String currentDB, String sql) {
        if (SchemaChange.matchesBlacklist(sql)) {
            return null;
        }
        while (true) {
            try {
                return SchemaChange.parseSQL(currentDB, sql);
            }
            catch (ReparseSQLException e) {
                sql = e.getSQL();
                LOGGER.debug("rewrote SQL to {}", (Object)sql);
                continue;
            }
            catch (ParseCancellationException e) {
                if (LOGGER.isDebugEnabled()) {
                    String msg = e.toString();
                    LOGGER.debug("Parse cancelled: {}", (Object)msg);
                }
                return null;
            }
            catch (MaxwellSQLSyntaxError e) {
                LOGGER.error("Error parsing SQL: '{}'", (Object)sql);
                throw e;
            }
            break;
        }
    }

    public abstract boolean isBlacklisted(Filter var1);

    static {
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*BEGIN", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*COMMIT", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*FLUSH", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*GRANT", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*REVOKE\\s+", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*SAVEPOINT", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*CREATE\\s+(AGGREGATE)?\\s+FUNCTION", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*(ALTER|CREATE)\\s+(DEFINER=[^\\s]+\\s+)?(EVENT|FUNCTION|TRIGGER|PROCEDURE)", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*DROP\\s+(EVENT|FUNCTION|TRIGGER|PROCEDURE|VIEW)", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*(ALTER|CREATE|DROP)\\s+((ONLINE|OFFLINE|UNIQUE|FULLTEXT|SPATIAL)\\s+)*(INDEX)", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*ANALYZE\\s+TABLE", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*SET\\s+PASSWORD", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*(ALTER|CREATE|DROP|RENAME)\\s+USER", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*ALTER\\s+INSTANCE.*", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*(ALTER|CREATE|DROP)\\s+TEMPORARY\\s+TABLE", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*(ALTER|CREATE|DROP)\\s+TABLESPACE", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*(SET|DROP|CREATE)\\s+(DEFAULT\\s+)?ROLE", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*TRUNCATE\\s+", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*OPTIMIZE\\s+", 10));
        SQL_BLACKLIST.add(Pattern.compile("\\A\\s*REPAIR\\s+", 10));
        DELETE_BLACKLIST = Pattern.compile("^\\s*DELETE\\s*FROM", 10);
        CSTYLE_COMMENTS = Pattern.compile("/\\*.*?\\*/", 32);
    }
}

