/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.columndef.StringColumnDef;
import com.zendesk.maxwell.schema.ddl.ColumnMod;
import com.zendesk.maxwell.schema.ddl.DeferredPositionUpdate;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedTableAlter;
import com.zendesk.maxwell.schema.ddl.SchemaChange;
import java.util.ArrayList;
import java.util.List;

public class TableAlter
extends SchemaChange {
    public String database;
    public String table;
    public ArrayList<ColumnMod> columnMods;
    public String newTableName;
    public String newDatabase;
    public String convertCharset;
    public String defaultCharset;
    public List<String> pks;

    public TableAlter(String database, String table) {
        this.database = database;
        this.table = table;
        this.columnMods = new ArrayList();
    }

    public String toString() {
        return "TableAlter<database: " + this.database + ", table:" + this.table + ">";
    }

    @Override
    public ResolvedTableAlter resolve(Schema schema) throws InvalidSchemaError {
        Database database = schema.findDatabaseOrThrow(this.database);
        Table oldTable = database.findTableOrThrow(this.table);
        Table table = oldTable.copy();
        if (this.newTableName != null && this.newDatabase != null) {
            schema.findDatabaseOrThrow(this.newDatabase);
            if (schema.getCaseSensitivity() == CaseSensitivity.CONVERT_TO_LOWER) {
                this.newTableName = this.newTableName.toLowerCase();
            }
            table.name = this.newTableName;
            table.database = this.newDatabase;
        }
        ArrayList<DeferredPositionUpdate> deferred = new ArrayList<DeferredPositionUpdate>();
        for (ColumnMod mod : this.columnMods) {
            mod.apply(table, deferred);
        }
        for (DeferredPositionUpdate def : deferred) {
            table.moveColumn(def.column, def.position);
        }
        if (this.convertCharset != null) {
            for (StringColumnDef sc : table.getStringColumns()) {
                if (sc.getCharset() != null && sc.getCharset().toLowerCase().equals("binary")) continue;
                table.replaceColumn(sc.getPos(), sc.withCharset(this.convertCharset));
            }
        }
        if (this.pks != null) {
            table.setPKList(this.pks);
        }
        if (this.defaultCharset != null) {
            table.charset = this.defaultCharset;
        }
        table.setDefaultColumnCharsets();
        return new ResolvedTableAlter(this.database, this.table, oldTable, table);
    }

    @Override
    public boolean isBlacklisted(Filter filter) {
        if (filter == null) {
            return false;
        }
        return filter.isTableBlacklisted(this.database, this.table);
    }
}

