/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.scripting;

import com.zendesk.maxwell.row.HeartbeatRowMap;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.schema.ddl.DDLMap;
import com.zendesk.maxwell.scripting.WrappedDDLMap;
import com.zendesk.maxwell.scripting.WrappedHeartbeatMap;
import com.zendesk.maxwell.scripting.WrappedRowMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scripting {
    static final Logger LOGGER = LoggerFactory.getLogger(Scripting.class);
    private final ScriptObjectMirror processRowFunc;
    private final ScriptObjectMirror processHeartbeatFunc;
    private final ScriptObjectMirror processDDLFunc;
    private LinkedHashMap<String, Object> globalJavascriptState;
    private static ThreadLocal<ScriptEngine> stringifyEngineThreadLocal = ThreadLocal.withInitial(() -> {
        ScriptEngineManager manager = new ScriptEngineManager();
        return manager.getEngineByName("nashorn");
    });

    private ScriptObjectMirror getFunc(ScriptEngine engine, String fName, String filename) {
        ScriptObjectMirror f = (ScriptObjectMirror)engine.get(fName);
        if (f == null) {
            return null;
        }
        if (!f.isFunction()) {
            throw new RuntimeException("Expected " + fName + " to be a function!");
        }
        LOGGER.info("using function " + fName + " from " + filename);
        return f;
    }

    public Scripting(String filename) throws IOException, ScriptException, NoSuchMethodException {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        String externJS = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        engine.put("logger", LOGGER);
        engine.eval(externJS);
        this.processRowFunc = this.getFunc(engine, "process_row", filename);
        this.processHeartbeatFunc = this.getFunc(engine, "process_heartbeat", filename);
        this.processDDLFunc = this.getFunc(engine, "process_ddl", filename);
        this.globalJavascriptState = new LinkedHashMap();
        if (this.processRowFunc == null && this.processHeartbeatFunc == null && this.processDDLFunc == null) {
            LOGGER.warn("expected " + filename + " to define at least one of: process_row,process_heartbeat,process_ddl");
        }
    }

    public void invoke(RowMap row) {
        if (row instanceof HeartbeatRowMap && this.processHeartbeatFunc != null) {
            this.processHeartbeatFunc.call(null, new Object[]{new WrappedHeartbeatMap((HeartbeatRowMap)row), this.globalJavascriptState});
        } else if (row instanceof DDLMap && this.processDDLFunc != null) {
            this.processDDLFunc.call(null, new Object[]{new WrappedDDLMap((DDLMap)row), this.globalJavascriptState});
        } else if (row instanceof RowMap && this.processRowFunc != null) {
            this.processRowFunc.call(null, new Object[]{new WrappedRowMap(row), this.globalJavascriptState});
        }
    }

    public static String stringify(ScriptObjectMirror mirror) throws ScriptException {
        ScriptObjectMirror json = (ScriptObjectMirror)stringifyEngineThreadLocal.get().eval("JSON");
        return (String)json.callMember("stringify", new Object[]{mirror});
    }
}

