/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.scripting;

import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.schema.ddl.DDLMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class WrappedDDLMap {
    private final DDLMap row;

    public WrappedDDLMap(DDLMap row) {
        this.row = row;
    }

    public LinkedHashMap<String, Object> getExtra_attributes() {
        return this.row.getExtraAttributes();
    }

    public String getType() {
        return this.row.getRowType();
    }

    public String getTable() {
        return this.row.getTable();
    }

    public String getDatabase() {
        return this.row.getDatabase();
    }

    public String getSql() {
        return this.row.getSql();
    }

    public Map<String, Object> getChange() {
        return this.row.getChangeMap();
    }

    public String getPosition() {
        BinlogPosition p = this.row.getPosition().getBinlogPosition();
        if (p == null) {
            return null;
        }
        if (p.getGtid() != null) {
            return p.getGtid();
        }
        return p.getFile() + ":" + p.getOffset();
    }

    public Long getTimestamp() {
        return this.row.getTimestamp();
    }

    public void suppress() {
        this.row.suppress();
    }

    public void setKafka_topic(String topic) {
        this.row.setKafkaTopic(topic);
    }
}

