/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.zendesk.maxwell.errors.DuplicateProcessException;
import com.zendesk.maxwell.util.ConnectionPool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C3P0ConnectionPool
implements ConnectionPool {
    private final ComboPooledDataSource cpds = new ComboPooledDataSource();
    static final Logger LOGGER = LoggerFactory.getLogger(C3P0ConnectionPool.class);

    @Override
    public Connection getConnection() throws SQLException {
        return this.cpds.getConnection();
    }

    @Override
    public void release() {
        this.cpds.close();
    }

    public C3P0ConnectionPool(String url, String user, String password) {
        this.cpds.setJdbcUrl(url);
        this.cpds.setUser(user);
        this.cpds.setPassword(password);
        this.cpds.setTestConnectionOnCheckout(true);
        this.cpds.setMinPoolSize(1);
        this.cpds.setMaxPoolSize(5);
    }

    @Override
    public void probe() throws SQLException {
        this.cpds.setAcquireRetryAttempts(1);
        try (Connection c = this.getConnection();){
            this.cpds.setAcquireRetryAttempts(30);
        }
        catch (SQLException e) {
            Throwable t = this.cpds.getLastAcquisitionFailureDefaultUser();
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new RuntimeException("couldn't get connection from pool", t);
        }
    }

    @Override
    public void withSQLRetry(int nTries, ConnectionPool.RetryableSQLFunction<Connection> inner) throws SQLException, DuplicateProcessException, NoSuchElementException {
        try (Connection c = this.getConnection();){
            inner.apply(c);
            return;
        }
        catch (SQLException e) {
            if (nTries <= 0) {
                throw e;
            }
            LOGGER.error("got SQL Exception: {}, retrying...", (Object)e.getLocalizedMessage());
            this.withSQLRetry(nTries - 1, inner);
            return;
        }
    }
}

