/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWithDiskBuffer<T> {
    static final Logger LOGGER = LoggerFactory.getLogger(ListWithDiskBuffer.class);
    private final long maxInMemoryElements;
    private final LinkedList<T> list;
    private long elementsInFile = 0L;
    private File file;
    private ObjectInputStream is;
    private ObjectOutputStream os;

    public ListWithDiskBuffer(long maxInMemoryElements) {
        this.maxInMemoryElements = maxInMemoryElements;
        this.list = new LinkedList();
    }

    public void add(T element) throws IOException {
        this.list.add(element);
        while (this.shouldBuffer()) {
            this.evict();
        }
    }

    protected boolean shouldBuffer() {
        return (long)this.list.size() > this.maxInMemoryElements;
    }

    protected void resetOutputStreamCaches() throws IOException {
        LOGGER.debug("Resetting OutputStream caches. elementsInFile: {}", (Object)this.elementsInFile);
        this.os.reset();
    }

    public void flushToDisk() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public T getLast() {
        return this.list.getLast();
    }

    public T removeFirst(Class<T> clazz) throws IOException, ClassNotFoundException {
        if (this.elementsInFile > 0L) {
            if (this.is == null) {
                this.os.flush();
                this.is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            }
            Object object = this.is.readObject();
            T element = clazz.cast(object);
            --this.elementsInFile;
            return element;
        }
        return this.list.removeFirst();
    }

    public Long size() {
        return (long)this.list.size() + this.elementsInFile;
    }

    public Long inMemorySize() {
        return this.list.size();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.file != null) {
                this.file.delete();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected T evict() throws IOException {
        if (this.file == null) {
            this.file = File.createTempFile("maxwell", "events");
            this.file.deleteOnExit();
            this.os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
        }
        if (this.elementsInFile == 0L) {
            LOGGER.info("Overflowed in-memory buffer, spilling over into " + this.file);
        }
        T evicted = this.list.removeFirst();
        this.os.writeObject(evicted);
        ++this.elementsInFile;
        if (this.elementsInFile % this.maxInMemoryElements == 0L) {
            this.resetOutputStreamCaches();
        }
        return evicted;
    }
}

