/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.OptionDescriptor;
import org.apache.commons.lang3.StringUtils;

public class MaxwellHelpFormatter
extends BuiltinHelpFormatter {
    private String section = null;
    private Map<String, ArrayList<String>> sections;
    private List<String> sectionNames;

    public MaxwellHelpFormatter(int desiredOverallWidth, int desiredColumnSeparatorWidth, Map<String, ArrayList<String>> sections, List<String> sectionNames) {
        super(desiredOverallWidth, desiredColumnSeparatorWidth);
        this.sections = sections;
        this.sectionNames = sectionNames;
    }

    public String format(Map<String, ? extends OptionDescriptor> options) {
        if (this.section != null && this.section.equalsIgnoreCase("all")) {
            this.addRows(options.values());
        } else {
            ArrayList<String> list = this.sections.get(this.section);
            if (list == null) {
                return "Unknown help section: " + this.section + "\n";
            }
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(options.values().toArray()[0]);
            for (String name : list) {
                l.add(options.get(name));
            }
            this.addRows(l);
        }
        Object output = this.formattedHelpOutput();
        output = ((String)output).replaceAll("--__separator_.*", "");
        Matcher matcher = Pattern.compile("--__section_(\\w+)\\s*").matcher((CharSequence)output);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String sectionName = matcher.group(1);
            matcher.appendReplacement(result, "\n" + matcher.group(1) + " options:\n");
            result.append(StringUtils.repeat((char)'-', (int)(matcher.group(1).length() + " options:".length())) + "\n");
        }
        matcher.appendTail(result);
        output = result.toString();
        output = (String)output + "\n--help [ all, " + StringUtils.join(this.sectionNames, (String)", ") + " ]\n";
        Pattern deprecated = Pattern.compile("^.*\\[deprecated\\].*\\n", 8);
        return deprecated.matcher((CharSequence)output).replaceAll("");
    }

    public void setSection(String section) {
        this.section = section;
    }
}

