/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.zendesk.maxwell.MaxwellMysqlConfig;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.filtering.InvalidFilterException;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticContext;
import com.zendesk.maxwell.monitoring.MaxwellHealthCheckFactory;
import com.zendesk.maxwell.producer.EncryptionMode;
import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.producer.ProducerFactory;
import com.zendesk.maxwell.replication.BinlogConnectorReplicator;
import com.zendesk.maxwell.replication.BinlogPosition;
import com.zendesk.maxwell.replication.Position;
import com.zendesk.maxwell.scripting.Scripting;
import com.zendesk.maxwell.util.AbstractConfig;
import com.zendesk.maxwell.util.MaxwellOptionParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import joptsimple.OptionSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class MaxwellConfig
extends AbstractConfig {
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellConfig.class);
    public static final String GTID_MODE_ENV = "GTID_MODE";
    public MaxwellMysqlConfig replicationMysql;
    public int replicationReconnectionRetries;
    public MaxwellMysqlConfig schemaMysql;
    public MaxwellMysqlConfig maxwellMysql;
    public Filter filter;
    public Boolean ignoreMissingSchema;
    public Boolean gtidMode = false;
    public String databaseName;
    public String excludeColumns;
    public String filterList;
    public ProducerFactory producerFactory;
    public final Properties customProducerProperties = new Properties();
    public MaxwellHealthCheckFactory customHealthFactory;
    public String producerType;
    public final Properties kafkaProperties = new Properties();
    public String kafkaTopic;
    public String deadLetterTopic;
    public String ddlKafkaTopic;
    public String kafkaKeyFormat;
    public String kafkaPartitionHash;
    public String bootstrapperType;
    public int bufferedProducerSize = 200;
    public String producerPartitionKey;
    public String producerPartitionColumns;
    public String producerPartitionFallback;
    public String kinesisStream;
    public boolean kinesisMd5Keys;
    public String sqsQueueUri;
    public String sqsServiceEndpoint;
    public String sqsSigningRegion;
    public String snsTopic;
    public String snsAttrs;
    public String pubsubProjectId;
    public String pubsubTopic;
    public String ddlPubsubTopic;
    public Long pubsubRequestBytesThreshold;
    public Long pubsubMessageCountBatchSize;
    public String pubsubMessageOrderingKey;
    public Duration pubsubPublishDelayThreshold;
    public Duration pubsubRetryDelay;
    public Float pubsubRetryDelayMultiplier;
    public Duration pubsubMaxRetryDelay;
    public Duration pubsubInitialRpcTimeout;
    public Float pubsubRpcTimeoutMultiplier;
    public Duration pubsubMaxRpcTimeout;
    public Duration pubsubTotalTimeout;
    public String pubsubEmulator;
    public String bigQueryProjectId;
    public String bigQueryDataset;
    public String bigQueryTable;
    public Long producerAckTimeout;
    public String outputFile;
    public MaxwellOutputConfig outputConfig;
    public String log_level;
    public MetricRegistry metricRegistry;
    public HealthCheckRegistry healthCheckRegistry;
    public int httpPort;
    public String httpBindAddress;
    public String httpPathPrefix;
    public String metricsPrefix;
    public String metricsReportingType;
    public Long metricsSlf4jInterval;
    public String metricsDatadogType;
    public String metricsDatadogTags;
    public String metricsDatadogAPIKey;
    public String metricsDatadogSite;
    public String metricsDatadogHost;
    public int metricsDatadogPort;
    public Long metricsDatadogInterval;
    public boolean metricsJvm;
    public int metricsAgeSlo;
    public MaxwellDiagnosticContext.Config diagnosticConfig;
    public boolean enableHttpConfig;
    public String clientID;
    public Long replicaServerID;
    public Position initPosition;
    public boolean replayMode = false;
    public boolean masterRecovery = false;
    public boolean ignoreProducerError;
    public boolean recaptureSchema;
    public float bufferMemoryUsage;
    public Integer maxSchemaDeltas;
    public String rabbitmqUser;
    public String rabbitmqPass;
    public String rabbitmqHost;
    public Integer rabbitmqPort;
    public String rabbitmqVirtualHost;
    public String rabbitmqURI;
    public Integer rabbitmqHandshakeTimeout;
    public String rabbitmqExchange;
    public String rabbitmqExchangeType;
    public boolean rabbitMqExchangeDurable;
    public boolean rabbitMqExchangeAutoDelete;
    public String rabbitmqRoutingKeyTemplate;
    public boolean rabbitmqMessagePersistent;
    public boolean rabbitmqDeclareExchange;
    public boolean rabbitmqUseSSL;
    public String natsUrl;
    public String natsSubject;
    public String redisHost;
    public int redisPort;
    public String redisAuth;
    public int redisDatabase;
    public String redisKey;
    public String redisStreamJsonKey;
    public String redisSentinels;
    public String redisSentinelMasterName;
    public String redisType;
    public String javascriptFile;
    public Scripting scripting;
    public boolean haMode;
    public String jgroupsConf;
    public String raftMemberID;
    public int binlogEventQueueSize;

    public MaxwellConfig() {
        this.replicationMysql = new MaxwellMysqlConfig();
        this.maxwellMysql = new MaxwellMysqlConfig();
        this.schemaMysql = new MaxwellMysqlConfig();
        this.outputConfig = new MaxwellOutputConfig();
        this.setup(null, null);
    }

    public MaxwellConfig(String[] argv) {
        this();
        this.parse(argv);
    }

    @Override
    protected MaxwellOptionParser buildOptionParser() {
        MaxwellOptionParser parser = new MaxwellOptionParser();
        parser.accepts("config", "location of config.properties file").withRequiredArg();
        parser.accepts("env_config", "json object encoded config in an environment variable").withRequiredArg();
        parser.separator();
        parser.accepts("producer", "producer type: stdout|file|kafka|kinesis|nats|pubsub|sns|sqs|rabbitmq|redis|custom").withRequiredArg();
        parser.accepts("client_id", "unique identifier for this maxwell instance, use when running multiple maxwells").withRequiredArg();
        parser.separator();
        parser.accepts("host", "main mysql host (contains `maxwell` database)").withRequiredArg();
        parser.accepts("port", "port for host").withRequiredArg().ofType(Integer.class);
        parser.accepts("user", "username for host").withRequiredArg();
        parser.accepts("password", "password for host").withRequiredArg();
        parser.section("mysql");
        parser.accepts("binlog_heartbeat", "enable binlog replication heartbeats, default false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("jdbc_options", "additional jdbc connection options: key1=val1&key2=val2").withRequiredArg();
        parser.accepts("ssl", "enables SSL for all connections: DISABLED|PREFERRED|REQUIRED|VERIFY_CA|VERIFY_IDENTITY. default: DISABLED").withRequiredArg();
        parser.accepts("replication_ssl", "overrides SSL setting for binlog connection: DISABLED|PREFERRED|REQUIRED|VERIFY_CA|VERIFY_IDENTITY").withRequiredArg();
        parser.accepts("schema_ssl", "overrides SSL setting for schema capture connection: DISABLED|PREFERRED|REQUIRED|VERIFY_CA|VERIFY_IDENTITY").withRequiredArg();
        parser.accepts("schema_database", "database name for maxwell state (schema and binlog position)").withRequiredArg();
        parser.accepts("replica_server_id", "server_id that maxwell reports to the master.  See docs for full explanation. ").withRequiredArg().ofType(Long.class);
        parser.accepts("replication_reconnection_retries", "define how many time should replicator try reconnect, default 1, 0 = unlimited").withOptionalArg().ofType(Integer.class);
        parser.separator();
        parser.accepts("replication_host", "mysql host to replicate from (if using separate schema-storage and replication servers)").withRequiredArg();
        parser.accepts("replication_user", "username for replication_host").withRequiredArg();
        parser.accepts("replication_password", "password for replication_host").withRequiredArg();
        parser.accepts("replication_port", "port for replication_host").withRequiredArg().ofType(Integer.class);
        parser.accepts("replication_jdbc_options", "additional jdbc connection options: key1=val1&key2=val2").withRequiredArg();
        parser.separator();
        parser.accepts("schema_host", "host to capture schema from (use only with MaxScale replication proxy)").withRequiredArg();
        parser.accepts("schema_user", "username for schema_host").withRequiredArg();
        parser.accepts("schema_password", "password for schema_host").withRequiredArg();
        parser.accepts("schema_port", "port for schema_host").withRequiredArg().ofType(Integer.class);
        parser.accepts("schema_jdbc_options", "additional jdbc connection options: key1=val1&key2=val2").withRequiredArg();
        parser.separator();
        parser.accepts("max_schemas", "Maximum schema-updates to keep before triggering a compaction operation.  Default: unlimited").withRequiredArg();
        parser.section("output");
        parser.accepts("output_binlog_position", "include 'position' (binlog position) field. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_gtid_position", "include 'gtid' (gtid position) field. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_commit_info", "include 'commit' and 'xid' field. default: true").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_xoffset", "include 'xoffset' (row offset inside transaction) field.  depends on '--output_commit_info'. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_nulls", "include data fields with NULL values. default: true").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_server_id", "include 'server_id' field. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_thread_id", "include 'thread_id' (client thread_id) field. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_schema_id", "include 'schema_id' (unique ID for this DDL). default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_row_query", "include 'query' field (original SQL DML query).  depends on server option 'binlog_rows_query_log_events'. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_primary_keys", "include 'primary_key' field (array of PK values). default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_primary_key_columns", "include 'primary_key_columns' field (array of PK column names). default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_null_zerodates", "convert '0000-00-00' dates/datetimes to null default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_ddl", "produce DDL records. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_push_timestamp", "include a microsecond timestamp representing when Maxwell sent a record. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("output_naming_strategy", "optionally use an alternate name for fields: underscore_to_camelcase").withOptionalArg().ofType(String.class);
        parser.accepts("exclude_columns", "suppress these comma-separated columns from output").withRequiredArg();
        parser.accepts("secret_key", "The secret key for the AES encryption").withRequiredArg();
        parser.accepts("encrypt", "encryption mode: [none|data|all]. default: none").withRequiredArg();
        parser.accepts("row_query_max_length", "truncates the 'query' field if it is above this length. default: 0 (disabled)").withOptionalArg().ofType(Integer.class);
        parser.section("filtering");
        parser.accepts("filter", "filter specs.  specify like \"include:db.*, exclude:*.tbl, include: foo./.*bar$/, exclude:foo.bar.baz=reject\"").withRequiredArg();
        parser.accepts("ignore_missing_schema", "Ignore missing database and table schemas.  Only use running with limited permissions.").withOptionalArg().ofType(Boolean.class);
        parser.accepts("javascript", "file containing per-row javascript to execute").withRequiredArg();
        parser.section("operation");
        parser.accepts("daemon", "run maxwell in the background").withOptionalArg().ofType(Boolean.class);
        parser.accepts("log_level", "DEBUG|INFO|WARN|ERROR").withRequiredArg();
        parser.accepts("env_config_prefix", "prefix of maxwell configuration environment variables, case insensitive").withRequiredArg();
        parser.separator();
        parser.accepts("ha", "enable high-availability mode via jgroups-raft").withOptionalArg().ofType(Boolean.class);
        parser.accepts("jgroups_config", "location of jgroups xml configuration file").withRequiredArg();
        parser.accepts("raft_member_id", "raft memberID.  (may also be specified in raft.xml)").withRequiredArg();
        parser.separator();
        parser.accepts("bootstrapper", "bootstrapper type: async|sync|none. default: async").withRequiredArg();
        parser.accepts("init_position", "initial binlog position, given as BINLOG_FILE:POSITION[:HEARTBEAT]").withRequiredArg();
        parser.accepts("replay", "replay mode: don't persist any schema changes or binlog position updates").withOptionalArg().ofType(Boolean.class);
        parser.accepts("master_recovery", "enable non-GTID master position recovery code").withOptionalArg().ofType(Boolean.class);
        parser.accepts("gtid_mode", "enable gtid mode").withOptionalArg().ofType(Boolean.class);
        parser.accepts("ignore_producer_error", "Maxwell will be terminated on kafka/kinesis errors when false. Otherwise, those producer errors are only logged. Default to true").withOptionalArg().ofType(Boolean.class);
        parser.accepts("recapture_schema", "recapture the latest schema.  Only use if Maxwell's schema has fallen out of sync").withOptionalArg().ofType(Boolean.class);
        parser.accepts("buffer_memory_usage", "Percentage of JVM memory available for transaction buffer.  Floating point between 0 and 1.").withRequiredArg().ofType(Float.class);
        parser.accepts("binlog_event_queue_size", "Size of queue to buffer events parsed from binlog.").withOptionalArg().ofType(Integer.class);
        parser.section("custom_producer");
        parser.accepts("custom_producer.factory", "fully qualified custom producer factory class").withRequiredArg();
        parser.section("file_producer");
        parser.accepts("output_file", "output file for 'file' producer").withRequiredArg();
        parser.section("kafka");
        parser.accepts("kafka.bootstrap.servers", "at least one kafka server, formatted as HOST:PORT[,HOST:PORT]").withRequiredArg();
        parser.accepts("kafka_topic", "optionally provide a topic name to push to. default: maxwell").withRequiredArg();
        parser.separator();
        parser.accepts("producer_partition_by", "database|table|primary_key|transaction_id|column|random, producer will partition by this value").withRequiredArg();
        parser.accepts("producer_partition_columns", "with producer_partition_by=column, partition by the value of these columns. comma separated.").withRequiredArg();
        parser.accepts("producer_partition_by_fallback", "database|table|primary_key|transaction_id, fallback to this value when using 'column' partitioning and the columns are not present in the row").withRequiredArg();
        parser.accepts("producer_ack_timeout", "producer message acknowledgement timeout in milliseconds").withRequiredArg().ofType(Long.class);
        parser.separator();
        parser.accepts("kafka_version", "kafka client library version: 0.8.2.2|0.9.0.1|0.10.0.1|0.10.2.1|0.11.0.1|1.0.0|2.7.0|3.4.0").withRequiredArg();
        parser.accepts("kafka_key_format", "how to format the kafka key; array|hash").withRequiredArg();
        parser.accepts("kafka_partition_hash", "default|murmur3, hash function for partitioning").withRequiredArg();
        parser.accepts("dead_letter_topic", "write to this topic when unable to publish a row for known reasons (eg message is too big)").withRequiredArg();
        parser.accepts("ddl_kafka_topic", "public DDL (schema change) events to this topic. default: kafka_topic ( see also --output_ddl )").withRequiredArg();
        parser.section("kinesis");
        parser.accepts("kinesis_stream", "kinesis stream name").withOptionalArg();
        parser.section("sqs");
        parser.accepts("sqs_queue_uri", "SQS Queue uri").withRequiredArg();
        parser.accepts("sqs_service_endpoint", "SQS Service Endpoint").withRequiredArg();
        parser.accepts("sqs_signing_region", "SQS Signing region").withRequiredArg();
        parser.section("sns");
        parser.accepts("sns_topic", "SNS Topic ARN").withRequiredArg();
        parser.accepts("sns_attrs", "Comma separated fields to add as message attributes: \"database, table\"").withOptionalArg();
        parser.separator();
        parser.addToSection("producer_partition_by");
        parser.addToSection("producer_partition_columns");
        parser.addToSection("producer_partition_by_fallback");
        parser.addToSection("producer_ack_timeout");
        parser.section("nats");
        parser.accepts("nats_url", "Url(s) of Nats connection (comma separated). Default is localhost:4222").withRequiredArg();
        parser.accepts("nats_subject", "Subject Hierarchies of Nats. Default is '%{database}.%{table}'").withRequiredArg();
        parser.section("bigquery");
        parser.accepts("bigquery_project_id", "provide a google cloud platform project id associated with the bigquery table").withRequiredArg();
        parser.accepts("bigquery_dataset", "provide a google cloud platform dataset id associated with the bigquery table").withRequiredArg();
        parser.accepts("bigquery_table", "provide a google cloud platform table id associated with the bigquery table").withRequiredArg();
        parser.section("pubsub");
        parser.accepts("pubsub_project_id", "provide a google cloud platform project id associated with the pubsub topic").withRequiredArg();
        parser.accepts("pubsub_topic", "pubsub topic. default: maxwell").withRequiredArg();
        parser.accepts("ddl_pubsub_topic", "alternate pubsub topic for DDL events. default: pubsub_topic").withRequiredArg();
        parser.accepts("pubsub_request_bytes_threshold", "threshold in bytes that triggers a batch to be sent. default: 1 byte").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_message_count_batch_size", "threshold in message count that triggers a batch to be sent. default: 1 message").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_message_ordering_key", "message ordering key template (will enable message ordering if specified). default: null").withOptionalArg();
        parser.accepts("pubsub_publish_delay_threshold", "threshold in delay time (milliseconds) before batch is sent. default: 1 ms").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_retry_delay", "delay in millis before sending the first retry message. default: 100 ms").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_retry_delay_multiplier", "multiply by this ratio to increase delay time each retry. default: 1.3").withRequiredArg().ofType(Float.class);
        parser.accepts("pubsub_max_retry_delay", "maximum retry delay time in seconds. default: 60 seconds").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_initial_rpc_timeout", "timeout for initial rpc call. default: 5 seconds").withRequiredArg();
        parser.accepts("pubsub_rpc_timeout_multiplier", "backoff delay ratio for rpc timeout. default: 1.0").withRequiredArg().ofType(Float.class);
        parser.accepts("pubsub_max_rpc_timeout", "max delay in seconds for rpc timeout. default: 600 seconds").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_total_timeout", "maximum timeout in seconds (clamps exponential backoff)").withRequiredArg().ofType(Long.class);
        parser.accepts("pubsub_emulator", "pubsub emulator host to use. default: null").withOptionalArg();
        parser.section("rabbitmq");
        parser.accepts("rabbitmq_user", "Username of Rabbitmq connection. Default is guest").withRequiredArg();
        parser.accepts("rabbitmq_pass", "Password of Rabbitmq connection. Default is guest").withRequiredArg();
        parser.accepts("rabbitmq_host", "Host of Rabbitmq machine").withRequiredArg();
        parser.accepts("rabbitmq_port", "Port of Rabbitmq machine").withRequiredArg().ofType(Integer.class);
        parser.accepts("rabbitmq_uri", "URI to rabbit server, eg amqp://, amqps://.  other rabbitmq options take precendence over uri.").withRequiredArg();
        parser.accepts("rabbitmq_handshake_timeout", "Handshake timeout of Rabbitmq connection in milliseconds").withOptionalArg().ofType(Integer.class);
        parser.accepts("rabbitmq_virtual_host", "Virtual Host of Rabbitmq").withRequiredArg();
        parser.accepts("rabbitmq_exchange", "Name of exchange for rabbitmq publisher").withRequiredArg();
        parser.accepts("rabbitmq_exchange_type", "Exchange type for rabbitmq").withRequiredArg();
        parser.accepts("rabbitmq_exchange_durable", "Exchange durability. Default is disabled").withOptionalArg();
        parser.accepts("rabbitmq_exchange_autodelete", "If set, the exchange is deleted when all queues have finished using it. Defaults to false").withOptionalArg();
        parser.accepts("rabbitmq_routing_key_template", "A string template for the routing key, '%db%' and '%table%' will be substituted. Default is '%db%.%table%'.").withRequiredArg();
        parser.accepts("rabbitmq_message_persistent", "Message persistence. Defaults to false").withOptionalArg();
        parser.accepts("rabbitmq_declare_exchange", "Should declare the exchange for rabbitmq publisher. Defaults to true").withOptionalArg();
        parser.accepts("rabbitmq_use_ssl", "If true, will connect to the server using SSL. Defaults to false").withOptionalArg();
        parser.section("redis");
        parser.accepts("redis_host", "Host of Redis server").withRequiredArg();
        parser.accepts("redis_port", "Port of Redis server").withRequiredArg().ofType(Integer.class);
        parser.accepts("redis_auth", "Authentication key for a password-protected Redis server").withRequiredArg();
        parser.accepts("redis_database", "Database of Redis server").withRequiredArg().ofType(Integer.class);
        parser.accepts("redis_type", "[pubsub|xadd|lpush|rpush] Selects either pubsub, xadd, lpush, or rpush. Defaults to 'pubsub'").withRequiredArg();
        parser.accepts("redis_key", "Redis channel/key for Pub/Sub, XADD or LPUSH/RPUSH").withRequiredArg();
        parser.accepts("redis_stream_json_key", "Redis Stream message field name for JSON message body").withRequiredArg();
        parser.accepts("redis_sentinels", "List of Redis sentinels in format host1:port1,host2:port2,host3:port3. It can be used instead of redis_host and redis_port").withRequiredArg();
        parser.accepts("redis_sentinel_master_name", "Redis sentinel master name. It is used with redis_sentinels").withRequiredArg();
        parser.section("monitoring");
        parser.accepts("metrics_prefix", "the prefix maxwell will apply to all metrics").withRequiredArg();
        parser.accepts("metrics_type", "how maxwell metrics will be reported, at least one of slf4j|jmx|http|datadog|stackdriver").withRequiredArg();
        parser.accepts("metrics_slf4j_interval", "the frequency metrics are emitted to the log, in seconds, when slf4j reporting is configured").withRequiredArg();
        parser.accepts("metrics_age_slo", "the threshold in seconds for message age service level objective").withRequiredArg().ofType(Integer.class);
        parser.accepts("metrics_jvm", "enable jvm metrics: true|false. default: false").withRequiredArg().ofType(Boolean.class);
        parser.accepts("metrics_datadog_type", "when metrics_type includes datadog this is the way metrics will be reported, one of udp|http").withRequiredArg();
        parser.accepts("metrics_datadog_tags", "datadog tags that should be supplied, e.g. tag1:value1,tag2:value2").withRequiredArg();
        parser.accepts("metrics_datadog_interval", "the frequency metrics are pushed to datadog, in seconds").withRequiredArg().ofType(Long.class);
        parser.accepts("metrics_datadog_apikey", "the datadog api key to use when metrics_datadog_type = http").withRequiredArg();
        parser.accepts("metrics_datadog_site", "the site to publish metrics to when metrics_datadog_type = http, one of us|eu, default us").withRequiredArg();
        parser.accepts("metrics_datadog_host", "the host to publish metrics to when metrics_datadog_type = udp").withRequiredArg();
        parser.accepts("metrics_datadog_port", "the port to publish metrics to when metrics_datadog_type = udp").withRequiredArg().ofType(Integer.class);
        parser.accepts("custom_health.factory", "fully qualified custom maxwell health check").withRequiredArg();
        parser.accepts("http_port", "the port the server will bind to when http reporting is configured").withRequiredArg().ofType(Integer.class);
        parser.accepts("http_path_prefix", "the http path prefix when metrics_type includes http or diagnostic is enabled, default /").withRequiredArg();
        parser.accepts("http_bind_address", "the ip address the server will bind to when http reporting is configured").withRequiredArg();
        parser.accepts("http_diagnostic", "enable http diagnostic endpoint: true|false. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("http_diagnostic_timeout", "the http diagnostic response timeout in ms when http_diagnostic=true. default: 10000").withRequiredArg().ofType(Integer.class);
        parser.accepts("http_config", "enable http config update endpoint: true|false. default: false").withOptionalArg().ofType(Boolean.class);
        parser.accepts("help", "display help").withOptionalArg().forHelp();
        return parser;
    }

    private void parse(String[] argv) {
        String envConfigPrefix;
        MaxwellOptionParser parser = this.buildOptionParser();
        OptionSet options = parser.parse(argv);
        Properties properties = options.has("config") ? this.parseFile((String)options.valueOf("config"), true) : this.parseFile("config.properties", false);
        if (options.has("env_config")) {
            Properties envConfigProperties = this.readPropertiesEnv((String)options.valueOf("env_config"));
            for (Map.Entry<Object, Object> entry : envConfigProperties.entrySet()) {
                Object key = entry.getKey();
                if (properties.put(key, entry.getValue()) == null) continue;
                LOGGER.debug("Replaced config key {} with value from env_config", key);
            }
        }
        if ((envConfigPrefix = this.fetchStringOption("env_config_prefix", options, properties, null)) != null) {
            String prefix = envConfigPrefix.toLowerCase();
            System.getenv().entrySet().stream().filter(map -> ((String)map.getKey()).toLowerCase().startsWith(prefix)).forEach(config -> {
                String rawKey = (String)config.getKey();
                String newKey = rawKey.toLowerCase().replaceFirst(prefix, "");
                if (properties.put(newKey, config.getValue()) != null) {
                    LOGGER.debug("Got env variable {} and replacing config key {}", (Object)rawKey, (Object)newKey);
                } else {
                    LOGGER.debug("Got env variable {} as config key {}", (Object)rawKey, (Object)newKey);
                }
            });
        }
        if (options.has("help")) {
            this.usage("Help for Maxwell:", parser, (String)options.valueOf("help"));
        }
        this.setup(options, properties);
        List arguments = options.nonOptionArguments();
        if (!arguments.isEmpty()) {
            this.usage("Unknown argument(s): " + arguments);
        }
    }

    private void setup(OptionSet options, Properties properties) {
        this.log_level = this.fetchStringOption("log_level", options, properties, null);
        this.maxwellMysql = this.parseMysqlConfig("", options, properties);
        this.replicationMysql = this.parseMysqlConfig("replication_", options, properties);
        this.schemaMysql = this.parseMysqlConfig("schema_", options, properties);
        this.gtidMode = this.fetchBooleanOption("gtid_mode", options, properties, System.getenv(GTID_MODE_ENV) != null);
        this.maxwellMysql.database = this.databaseName = this.fetchStringOption("schema_database", options, properties, "maxwell");
        this.producerFactory = this.fetchProducerFactory(options, properties);
        this.producerType = this.fetchStringOption("producer", options, properties, "stdout");
        this.producerAckTimeout = this.fetchLongOption("producer_ack_timeout", options, properties, 0L);
        this.bootstrapperType = this.fetchStringOption("bootstrapper", options, properties, "async");
        this.clientID = this.fetchStringOption("client_id", options, properties, "maxwell");
        this.replicaServerID = this.fetchLongOption("replica_server_id", options, properties, 6379L);
        this.javascriptFile = this.fetchStringOption("javascript", options, properties, null);
        this.kafkaTopic = this.fetchStringOption("kafka_topic", options, properties, "maxwell");
        this.deadLetterTopic = this.fetchStringOption("dead_letter_topic", options, properties, null);
        this.kafkaKeyFormat = this.fetchStringOption("kafka_key_format", options, properties, "hash");
        this.kafkaPartitionHash = this.fetchStringOption("kafka_partition_hash", options, properties, "default");
        this.ddlKafkaTopic = this.fetchStringOption("ddl_kafka_topic", options, properties, this.kafkaTopic);
        this.bigQueryProjectId = this.fetchStringOption("bigquery_project_id", options, properties, null);
        this.bigQueryDataset = this.fetchStringOption("bigquery_dataset", options, properties, null);
        this.bigQueryTable = this.fetchStringOption("bigquery_table", options, properties, null);
        this.pubsubProjectId = this.fetchStringOption("pubsub_project_id", options, properties, null);
        this.pubsubTopic = this.fetchStringOption("pubsub_topic", options, properties, "maxwell");
        this.ddlPubsubTopic = this.fetchStringOption("ddl_pubsub_topic", options, properties, this.pubsubTopic);
        this.pubsubRequestBytesThreshold = this.fetchLongOption("pubsub_request_bytes_threshold", options, properties, 1L);
        this.pubsubMessageCountBatchSize = this.fetchLongOption("pubsub_message_count_batch_size", options, properties, 1L);
        this.pubsubMessageOrderingKey = this.fetchStringOption("pubsub_message_ordering_key", options, properties, null);
        this.pubsubPublishDelayThreshold = Duration.ofMillis((long)this.fetchLongOption("pubsub_publish_delay_threshold", options, properties, 1L));
        this.pubsubRetryDelay = Duration.ofMillis((long)this.fetchLongOption("pubsub_retry_delay", options, properties, 100L));
        this.pubsubRetryDelayMultiplier = this.fetchFloatOption("pubsub_retry_delay_multiplier", options, properties, Float.valueOf(1.3f));
        this.pubsubMaxRetryDelay = Duration.ofSeconds((long)this.fetchLongOption("pubsub_max_retry_delay", options, properties, 60L));
        this.pubsubInitialRpcTimeout = Duration.ofSeconds((long)this.fetchLongOption("pubsub_initial_rpc_timeout", options, properties, 5L));
        this.pubsubRpcTimeoutMultiplier = this.fetchFloatOption("pubsub_rpc_timeout_multiplier", options, properties, Float.valueOf(1.0f));
        this.pubsubMaxRpcTimeout = Duration.ofSeconds((long)this.fetchLongOption("pubsub_max_rpc_timeout", options, properties, 600L));
        this.pubsubTotalTimeout = Duration.ofSeconds((long)this.fetchLongOption("pubsub_total_timeout", options, properties, 600L));
        this.pubsubEmulator = this.fetchStringOption("pubsub_emulator", options, properties, null);
        this.rabbitmqHost = this.fetchStringOption("rabbitmq_host", options, properties, null);
        this.rabbitmqPort = this.fetchIntegerOption("rabbitmq_port", options, properties, null);
        this.rabbitmqUser = this.fetchStringOption("rabbitmq_user", options, properties, "guest");
        this.rabbitmqPass = this.fetchStringOption("rabbitmq_pass", options, properties, "guest");
        this.rabbitmqVirtualHost = this.fetchStringOption("rabbitmq_virtual_host", options, properties, "/");
        this.rabbitmqURI = this.fetchStringOption("rabbitmq_uri", options, properties, null);
        this.rabbitmqHandshakeTimeout = this.fetchIntegerOption("rabbitmq_handshake_timeout", options, properties, null);
        this.rabbitmqExchange = this.fetchStringOption("rabbitmq_exchange", options, properties, "maxwell");
        this.rabbitmqExchangeType = this.fetchStringOption("rabbitmq_exchange_type", options, properties, "fanout");
        this.rabbitMqExchangeDurable = this.fetchBooleanOption("rabbitmq_exchange_durable", options, properties, false);
        this.rabbitMqExchangeAutoDelete = this.fetchBooleanOption("rabbitmq_exchange_autodelete", options, properties, false);
        this.rabbitmqRoutingKeyTemplate = this.fetchStringOption("rabbitmq_routing_key_template", options, properties, "%db%.%table%");
        this.rabbitmqMessagePersistent = this.fetchBooleanOption("rabbitmq_message_persistent", options, properties, false);
        this.rabbitmqDeclareExchange = this.fetchBooleanOption("rabbitmq_declare_exchange", options, properties, true);
        this.rabbitmqUseSSL = this.fetchBooleanOption("rabbitmq_use_ssl", options, properties, false);
        this.natsUrl = this.fetchStringOption("nats_url", options, properties, "nats://localhost:4222");
        this.natsSubject = this.fetchStringOption("nats_subject", options, properties, "%{database}.%{table}");
        this.redisHost = this.fetchStringOption("redis_host", options, properties, "localhost");
        this.redisPort = this.fetchIntegerOption("redis_port", options, properties, 6379);
        this.redisAuth = this.fetchStringOption("redis_auth", options, properties, null);
        this.redisDatabase = this.fetchIntegerOption("redis_database", options, properties, 0);
        this.redisKey = this.fetchStringOption("redis_key", options, properties, "maxwell");
        this.redisStreamJsonKey = this.fetchStringOption("redis_stream_json_key", options, properties, "message");
        this.redisSentinels = this.fetchStringOption("redis_sentinels", options, properties, null);
        this.redisSentinelMasterName = this.fetchStringOption("redis_sentinel_master_name", options, properties, null);
        this.redisType = this.fetchStringOption("redis_type", options, properties, "pubsub");
        String kafkaBootstrapServers = this.fetchStringOption("kafka.bootstrap.servers", options, properties, null);
        if (kafkaBootstrapServers != null) {
            this.kafkaProperties.setProperty("bootstrap.servers", kafkaBootstrapServers);
        }
        if (properties != null) {
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (k.startsWith("custom_producer.")) {
                    this.customProducerProperties.setProperty(k.replace("custom_producer.", ""), properties.getProperty(k));
                    continue;
                }
                if (k.startsWith("custom_producer_")) {
                    this.customProducerProperties.setProperty(k.replace("custom_producer_", ""), properties.getProperty(k));
                    continue;
                }
                if (!k.startsWith("kafka.") || k.equals("kafka.bootstrap.servers") && kafkaBootstrapServers != null) continue;
                this.kafkaProperties.setProperty(k.replace("kafka.", ""), properties.getProperty(k));
            }
        }
        this.producerPartitionKey = this.fetchStringOption("producer_partition_by", options, properties, "database");
        this.producerPartitionColumns = this.fetchStringOption("producer_partition_columns", options, properties, null);
        this.producerPartitionFallback = this.fetchStringOption("producer_partition_by_fallback", options, properties, null);
        this.kinesisStream = this.fetchStringOption("kinesis_stream", options, properties, null);
        this.kinesisMd5Keys = this.fetchBooleanOption("kinesis_md5_keys", options, properties, false);
        this.sqsQueueUri = this.fetchStringOption("sqs_queue_uri", options, properties, null);
        this.sqsServiceEndpoint = this.fetchStringOption("sqs_service_endpoint", options, properties, null);
        this.sqsSigningRegion = this.fetchStringOption("sqs_signing_region", options, properties, null);
        this.snsTopic = this.fetchStringOption("sns_topic", options, properties, null);
        this.snsAttrs = this.fetchStringOption("sns_attrs", options, properties, null);
        this.outputFile = this.fetchStringOption("output_file", options, properties, null);
        this.metricsPrefix = this.fetchStringOption("metrics_prefix", options, properties, "MaxwellMetrics");
        this.metricsReportingType = this.fetchStringOption("metrics_type", options, properties, null);
        this.metricsSlf4jInterval = this.fetchLongOption("metrics_slf4j_interval", options, properties, 60L);
        this.customHealthFactory = this.fetchHealthCheckFactory(options, properties);
        this.httpPort = this.fetchIntegerOption("http_port", options, properties, 8080);
        this.httpBindAddress = this.fetchStringOption("http_bind_address", options, properties, null);
        this.httpPathPrefix = this.fetchStringOption("http_path_prefix", options, properties, "/");
        if (!this.httpPathPrefix.startsWith("/")) {
            this.httpPathPrefix = "/" + this.httpPathPrefix;
        }
        this.metricsDatadogType = this.fetchStringOption("metrics_datadog_type", options, properties, "udp");
        this.metricsDatadogTags = this.fetchStringOption("metrics_datadog_tags", options, properties, "");
        this.metricsDatadogAPIKey = this.fetchStringOption("metrics_datadog_apikey", options, properties, "");
        this.metricsDatadogSite = this.fetchStringOption("metrics_datadog_site", options, properties, "us");
        this.metricsDatadogHost = this.fetchStringOption("metrics_datadog_host", options, properties, "localhost");
        this.metricsDatadogPort = this.fetchIntegerOption("metrics_datadog_port", options, properties, 8125);
        this.metricsDatadogInterval = this.fetchLongOption("metrics_datadog_interval", options, properties, 60L);
        this.metricsJvm = this.fetchBooleanOption("metrics_jvm", options, properties, false);
        this.metricsAgeSlo = this.fetchIntegerOption("metrics_age_slo", options, properties, Integer.MAX_VALUE);
        this.diagnosticConfig = new MaxwellDiagnosticContext.Config();
        this.diagnosticConfig.enable = this.fetchBooleanOption("http_diagnostic", options, properties, false);
        this.diagnosticConfig.timeout = this.fetchLongOption("http_diagnostic_timeout", options, properties, 10000L);
        this.enableHttpConfig = this.fetchBooleanOption("http_config", options, properties, false);
        this.filterList = this.fetchStringOption("filter", options, properties, null);
        this.ignoreMissingSchema = this.fetchBooleanOption("ignore_missing_schema", options, properties, false);
        this.setupInitPosition(options);
        this.replayMode = this.fetchBooleanOption("replay", options, null, false);
        this.masterRecovery = this.fetchBooleanOption("master_recovery", options, properties, false);
        this.ignoreProducerError = this.fetchBooleanOption("ignore_producer_error", options, properties, true);
        this.recaptureSchema = this.fetchBooleanOption("recapture_schema", options, null, false);
        this.bufferMemoryUsage = this.fetchFloatOption("buffer_memory_usage", options, properties, Float.valueOf(0.25f)).floatValue();
        this.maxSchemaDeltas = this.fetchIntegerOption("max_schemas", options, properties, null);
        this.outputConfig.includesBinlogPosition = this.fetchBooleanOption("output_binlog_position", options, properties, false);
        this.outputConfig.includesGtidPosition = this.fetchBooleanOption("output_gtid_position", options, properties, false);
        this.outputConfig.includesCommitInfo = this.fetchBooleanOption("output_commit_info", options, properties, true);
        this.outputConfig.includesXOffset = this.fetchBooleanOption("output_xoffset", options, properties, true);
        this.outputConfig.includesNulls = this.fetchBooleanOption("output_nulls", options, properties, true);
        this.outputConfig.includesServerId = this.fetchBooleanOption("output_server_id", options, properties, false);
        this.outputConfig.includesThreadId = this.fetchBooleanOption("output_thread_id", options, properties, false);
        this.outputConfig.includesSchemaId = this.fetchBooleanOption("output_schema_id", options, properties, false);
        this.outputConfig.includesRowQuery = this.fetchBooleanOption("output_row_query", options, properties, false);
        this.outputConfig.rowQueryMaxLength = this.fetchIntegerOption("row_query_max_length", options, properties, 0);
        this.outputConfig.includesPrimaryKeys = this.fetchBooleanOption("output_primary_keys", options, properties, false);
        this.outputConfig.includesPrimaryKeyColumns = this.fetchBooleanOption("output_primary_key_columns", options, properties, false);
        this.outputConfig.includesPushTimestamp = this.fetchBooleanOption("output_push_timestamp", options, properties, false);
        this.outputConfig.outputDDL = this.fetchBooleanOption("output_ddl", options, properties, false);
        this.outputConfig.zeroDatesAsNull = this.fetchBooleanOption("output_null_zerodates", options, properties, false);
        this.outputConfig.namingStrategy = this.fetchStringOption("output_naming_strategy", options, properties, null);
        this.excludeColumns = this.fetchStringOption("exclude_columns", options, properties, null);
        this.setupEncryptionOptions(options, properties);
        this.haMode = this.fetchBooleanOption("ha", options, properties, false);
        this.jgroupsConf = this.fetchStringOption("jgroups_config", options, properties, "raft.xml");
        this.raftMemberID = this.fetchStringOption("raft_member_id", options, properties, null);
        this.replicationReconnectionRetries = this.fetchIntegerOption("replication_reconnection_retries", options, properties, 1);
        this.binlogEventQueueSize = this.fetchIntegerOption("binlog_event_queue_size", options, properties, BinlogConnectorReplicator.BINLOG_QUEUE_SIZE);
    }

    private void setupEncryptionOptions(OptionSet options, Properties properties) {
        String encryptionMode;
        switch (encryptionMode = this.fetchStringOption("encrypt", options, properties, "none")) {
            case "none": {
                this.outputConfig.encryptionMode = EncryptionMode.ENCRYPT_NONE;
                break;
            }
            case "data": {
                this.outputConfig.encryptionMode = EncryptionMode.ENCRYPT_DATA;
                break;
            }
            case "all": {
                this.outputConfig.encryptionMode = EncryptionMode.ENCRYPT_ALL;
                break;
            }
            default: {
                this.usage("Unknown encryption mode: " + encryptionMode);
            }
        }
        if (this.outputConfig.encryptionEnabled()) {
            this.outputConfig.secretKey = this.fetchStringOption("secret_key", options, properties, null);
        }
    }

    private void setupInitPosition(OptionSet options) {
        if (options != null && options.has("init_position")) {
            String initPosition = (String)options.valueOf("init_position");
            String[] initPositionSplit = initPosition.split(":");
            if (initPositionSplit.length < 2) {
                this.usageForOptions("Invalid init_position: " + initPosition, "--init_position");
            }
            Long pos = 0L;
            try {
                pos = Long.valueOf(initPositionSplit[1]);
            }
            catch (NumberFormatException e) {
                this.usageForOptions("Invalid init_position: " + initPosition, "--init_position");
            }
            Long lastHeartbeat = 0L;
            if (initPositionSplit.length > 2) {
                try {
                    lastHeartbeat = Long.valueOf(initPositionSplit[2]);
                }
                catch (NumberFormatException e) {
                    this.usageForOptions("Invalid init_position: " + initPosition, "--init_position");
                }
            }
            this.initPosition = new Position(new BinlogPosition(pos, initPositionSplit[0]), lastHeartbeat);
        }
    }

    private Properties parseFile(String filename, Boolean abortOnMissing) {
        Properties p = this.readPropertiesFile(filename, abortOnMissing);
        if (p == null) {
            p = new Properties();
        }
        return p;
    }

    private void validatePartitionBy() {
        Object[] validPartitionBy = new String[]{"database", "table", "primary_key", "transaction_id", "thread_id", "column", "random"};
        if (this.producerPartitionKey == null) {
            this.producerPartitionKey = "database";
        } else if (!ArrayUtils.contains((Object[])validPartitionBy, (Object)this.producerPartitionKey)) {
            this.usageForOptions("please specify --producer_partition_by=database|table|primary_key|transaction_id|thread_id|column|random", "producer_partition_by");
        } else if (this.producerPartitionKey.equals("column") && StringUtils.isEmpty((CharSequence)this.producerPartitionColumns)) {
            this.usageForOptions("please specify --producer_partition_columns=column1 when using producer_partition_by=column", "producer_partition_columns");
        } else if (this.producerPartitionKey.equals("column") && StringUtils.isEmpty((CharSequence)this.producerPartitionFallback)) {
            this.usageForOptions("please specify --producer_partition_by_fallback=[database, table, primary_key, transaction_id] when using producer_partition_by=column", "producer_partition_by_fallback");
        }
    }

    private void validateFilter() {
        if (this.filter != null) {
            return;
        }
        try {
            this.filter = this.filterList != null ? new Filter(this.databaseName, this.filterList) : new Filter(this.databaseName, "");
        }
        catch (InvalidFilterException e) {
            this.usageForOptions("Invalid filter options: " + e.getLocalizedMessage(), "filter");
        }
    }

    public void validate() {
        this.validatePartitionBy();
        this.validateFilter();
        if (this.producerType.equals("kafka")) {
            if (!this.kafkaProperties.containsKey("bootstrap.servers")) {
                this.usageForOptions("Please specify kafka.bootstrap.servers", "kafka");
            }
            if (this.kafkaPartitionHash == null) {
                this.kafkaPartitionHash = "default";
            } else if (!this.kafkaPartitionHash.equals("default") && !this.kafkaPartitionHash.equals("murmur3")) {
                this.usageForOptions("please specify --kafka_partition_hash=default|murmur3", "kafka_partition_hash");
            }
            if (!this.kafkaKeyFormat.equals("hash") && !this.kafkaKeyFormat.equals("array")) {
                this.usageForOptions("invalid kafka_key_format: " + this.kafkaKeyFormat, "kafka_key_format");
            }
        } else if (this.producerType.equals("file") && this.outputFile == null) {
            this.usageForOptions("please specify --output_file=FILE to use the file producer", "--producer", "--output_file");
        } else if (this.producerType.equals("kinesis") && this.kinesisStream == null) {
            this.usageForOptions("please specify a stream name for kinesis", "kinesis_stream");
        } else if (this.producerType.equals("sqs") && this.sqsQueueUri == null) {
            this.usageForOptions("please specify a queue uri for sqs", "sqs_queue_uri");
        } else if (this.producerType.equals("sqs") && this.sqsServiceEndpoint == null) {
            this.usageForOptions("please specify a service endpoint for sqs", "sqs_service_endpoint");
        } else if (this.producerType.equals("sqs") && this.sqsSigningRegion == null) {
            this.usageForOptions("please specify a signing region for sqs", "sqs_signing_region");
        } else if (this.producerType.equals("sns") && this.snsTopic == null) {
            this.usageForOptions("please specify a topic ARN for SNS", "sns_topic");
        } else if (this.producerType.equals("pubsub")) {
            if (this.pubsubProjectId == null) {
                this.usageForOptions("please specify --pubsub_project_id.", "--pubsub_project_id");
            }
            if (this.pubsubRequestBytesThreshold <= 0L) {
                this.usage("--pubsub_request_bytes_threshold must be > 0");
            }
            if (this.pubsubMessageCountBatchSize <= 0L) {
                this.usage("--pubsub_message_count_batch_size must be > 0");
            }
            if (this.pubsubPublishDelayThreshold.isNegative() || this.pubsubPublishDelayThreshold.isZero()) {
                this.usage("--pubsub_publish_delay_threshold must be > 0");
            }
            if (this.pubsubRetryDelay.isNegative() || this.pubsubRetryDelay.isZero()) {
                this.usage("--pubsub_retry_delay must be > 0");
            }
            if ((double)this.pubsubRetryDelayMultiplier.floatValue() <= 1.0) {
                this.usage("--pubsub_retry_delay_multiplier must be > 1.0");
            }
            if (this.pubsubMaxRetryDelay.isNegative() || this.pubsubMaxRetryDelay.isZero()) {
                this.usage("--pubsub_max_retry_delay must be > 0");
            }
            if (this.pubsubInitialRpcTimeout.isNegative() || this.pubsubInitialRpcTimeout.isZero()) {
                this.usage("--pubsub_initial_rpc_timeout must be > 0");
            }
            if ((double)this.pubsubRpcTimeoutMultiplier.floatValue() < 1.0) {
                this.usage("--pubsub_rpc_timeout_multiplier must be >= 1.0");
            }
            if (this.pubsubMaxRpcTimeout.isNegative() || this.pubsubMaxRpcTimeout.isZero()) {
                this.usage("--pubsub_max_rpc_timeout must be > 0");
            }
            if (this.pubsubTotalTimeout.isNegative() || this.pubsubTotalTimeout.isZero()) {
                this.usage("--pubsub_total_timeout must be > 0");
            }
        } else if (this.producerType.equals("redis")) {
            if (this.redisKey == null) {
                this.usage("please specify --redis_key=KEY");
            }
            if (this.redisSentinelMasterName != null && this.redisSentinels == null || this.redisSentinels != null && this.redisSentinelMasterName == null) {
                this.usageForOptions("please specify both (or none) of redis_sentinel_master_name and redis_sentinels", new String[0]);
            }
        }
        if (!(this.bootstrapperType.equals("async") || this.bootstrapperType.equals("sync") || this.bootstrapperType.equals("none"))) {
            this.usageForOptions("please specify --bootstrapper=async|sync|none", "--bootstrapper");
        }
        if (this.maxwellMysql.sslMode == null) {
            this.maxwellMysql.sslMode = SSLMode.DISABLED;
        }
        if (this.maxwellMysql.host == null) {
            LOGGER.warn("maxwell mysql host not specified, defaulting to localhost");
            this.maxwellMysql.host = "localhost";
        }
        if (this.replicationMysql.host == null || this.replicationMysql.user == null) {
            if (this.replicationMysql.host != null || this.replicationMysql.user != null || this.replicationMysql.password != null) {
                this.usageForOptions("Please specify all of: replication_host, replication_user, replication_password", "--replication");
            }
            this.replicationMysql = new MaxwellMysqlConfig(this.maxwellMysql.host, this.maxwellMysql.port, null, this.maxwellMysql.user, this.maxwellMysql.password, this.maxwellMysql.sslMode, this.maxwellMysql.enableHeartbeat);
            this.replicationMysql.jdbcOptions = this.maxwellMysql.jdbcOptions;
        }
        if (this.replicationMysql.sslMode == null) {
            this.replicationMysql.sslMode = this.maxwellMysql.sslMode;
        }
        if (this.gtidMode.booleanValue() && this.masterRecovery) {
            this.usageForOptions("There is no need to perform master_recovery under gtid_mode", "--gtid_mode");
        }
        if (this.outputConfig.includesGtidPosition && !this.gtidMode.booleanValue()) {
            this.usageForOptions("output_gtid_position is only support with gtid mode.", "--output_gtid_position");
        }
        if (this.schemaMysql.host != null) {
            if (this.schemaMysql.user == null || this.schemaMysql.password == null) {
                this.usageForOptions("Please specify all of: schema_host, schema_user, schema_password", "--schema");
            }
            if (this.replicationMysql.host == null) {
                this.usageForOptions("Specifying schema_host only makes sense along with replication_host", new String[0]);
            }
        }
        if (this.schemaMysql.sslMode == null) {
            this.schemaMysql.sslMode = this.maxwellMysql.sslMode;
        }
        if (this.metricsDatadogType.contains("http") && StringUtils.isEmpty((CharSequence)this.metricsDatadogAPIKey)) {
            this.usageForOptions("please specify metrics_datadog_apikey when metrics_datadog_type = http", new String[0]);
        }
        if (this.excludeColumns != null) {
            for (String s : this.excludeColumns.split(",")) {
                try {
                    this.outputConfig.excludeColumns.add(MaxwellConfig.compileStringToPattern(s));
                }
                catch (InvalidFilterException e) {
                    this.usage("invalid exclude_columns: '" + this.excludeColumns + "': " + e.getMessage());
                }
            }
        }
        if (this.outputConfig.encryptionEnabled() && this.outputConfig.secretKey == null) {
            this.usage("--secret_key required");
        }
        if (this.bufferMemoryUsage > 1.0f) {
            this.usage("--buffer_memory_usage must be <= 1.0");
        }
        if (this.javascriptFile != null) {
            try {
                this.scripting = new Scripting(this.javascriptFile);
            }
            catch (Exception e) {
                LOGGER.error("Error setting up javascript: ", (Throwable)e);
                System.exit(1);
            }
        }
        if (this.maxSchemaDeltas != null && this.maxSchemaDeltas <= 1) {
            this.usageForOptions("--max_schemas must a number between 1 and 2**31", "--max_schemas");
        }
    }

    public Properties getKafkaProperties() {
        return this.kafkaProperties;
    }

    private static Pattern compileStringToPattern(String name) throws InvalidFilterException {
        if ((name = name.trim()).startsWith("/")) {
            if (!name.endsWith("/")) {
                throw new InvalidFilterException("Invalid regular expression: " + name);
            }
            return Pattern.compile(name.substring(1, name.length() - 1));
        }
        return Pattern.compile("^" + Pattern.quote(name) + "$");
    }

    private <T> T fetchFactory(OptionSet options, Properties properties, String name) {
        String strOption = this.fetchStringOption(name, options, properties, null);
        if (strOption != null) {
            try {
                Class<?> clazz = Class.forName(strOption);
                Class[] carg = new Class[]{};
                Constructor<?> ct = clazz.getDeclaredConstructor(carg);
                return (T)ct.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                this.usageForOptions("Invalid value for " + name + ", class '" + strOption + "' not found", "--" + name);
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException e) {
                this.usageForOptions("Invalid value for " + name + ", class instantiation error", "--" + name);
            }
            catch (NoSuchMethodException e) {
                this.usageForOptions("No valid constructor found for " + strOption, "--" + name);
            }
            catch (InvocationTargetException e) {
                String msg = String.format("Unable to construct customer producer '%s'", strOption);
                this.usageForOptions(msg, "--" + name);
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    protected ProducerFactory fetchProducerFactory(OptionSet options, Properties properties) {
        return (ProducerFactory)this.fetchFactory(options, properties, "custom_producer.factory");
    }

    protected MaxwellHealthCheckFactory fetchHealthCheckFactory(OptionSet options, Properties properties) {
        return (MaxwellHealthCheckFactory)this.fetchFactory(options, properties, "custom_health.factory");
    }

    public Boolean getIgnoreMissingSchema() {
        return this.ignoreMissingSchema;
    }

    public void setIgnoreMissingSchema(Boolean ignoreMissingSchema) {
        this.ignoreMissingSchema = ignoreMissingSchema;
    }
}

