/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell;

import com.github.shyiko.mysql.binlog.network.SSLMode;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;

public class MaxwellMysqlConfig {
    public String host = null;
    public Integer port = null;
    public String database = null;
    public String user = null;
    public String password = null;
    public SSLMode sslMode = null;
    public boolean enableHeartbeat = false;
    public Map<String, String> jdbcOptions = new HashMap<String, String>();
    public Integer connectTimeoutMS = 5000;

    public MaxwellMysqlConfig() {
        this.jdbcOptions.put("zeroDateTimeBehavior", "convertToNull");
        this.jdbcOptions.put("connectTimeout", String.valueOf(this.connectTimeoutMS));
        this.jdbcOptions.put("allowPublicKeyRetrieval", "true");
    }

    public MaxwellMysqlConfig(String host, Integer port, String database, String user, String password, SSLMode sslMode, boolean enableHeartbeat) {
        this();
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
        this.sslMode = sslMode;
        this.enableHeartbeat = enableHeartbeat;
    }

    public MaxwellMysqlConfig(MaxwellMysqlConfig c) {
        this();
        this.host = c.host;
        this.port = c.port;
        this.database = c.database;
        this.user = c.user;
        this.password = c.password;
        this.sslMode = c.sslMode;
    }

    private void useSSL(boolean should) {
        this.jdbcOptions.put("useSSL", String.valueOf(should));
    }

    private void requireSSL(boolean should) {
        this.jdbcOptions.put("requireSSL", String.valueOf(should));
    }

    private void verifyServerCertificate(boolean should) {
        this.jdbcOptions.put("verifyServerCertificate", String.valueOf(should));
    }

    public void setJDBCOptions(String opts) {
        if (opts == null) {
            return;
        }
        for (String opt : opts.split("&")) {
            String[] valueKeySplit = opt.trim().split("=", 2);
            if (valueKeySplit.length != 2) continue;
            this.jdbcOptions.put(valueKeySplit[0], valueKeySplit[1]);
        }
    }

    private void setSSLOptions() {
        if (this.sslMode != null && this.sslMode != SSLMode.DISABLED) {
            this.useSSL(true);
            this.verifyServerCertificate(false);
            this.requireSSL(false);
            this.requireSSL(this.sslMode == SSLMode.REQUIRED || this.sslMode == SSLMode.VERIFY_CA || this.sslMode == SSLMode.VERIFY_IDENTITY);
            this.verifyServerCertificate(this.sslMode == SSLMode.VERIFY_IDENTITY);
        } else {
            this.useSSL(false);
        }
    }

    public String getConnectionURI(boolean includeDatabase) throws URISyntaxException {
        this.setSSLOptions();
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("jdbc:mysql");
        uriBuilder.setHost(this.host);
        uriBuilder.setPort(this.port.intValue());
        if (this.database != null && includeDatabase) {
            uriBuilder.setPath("/" + this.database);
        }
        for (Map.Entry<String, String> jdbcOption : this.jdbcOptions.entrySet()) {
            uriBuilder.addParameter(jdbcOption.getKey(), jdbcOption.getValue());
        }
        uriBuilder.addParameter("characterEncoding", "UTF-8");
        uriBuilder.addParameter("tinyInt1isBit", "false");
        return uriBuilder.build().toString();
    }

    public String getConnectionURI() throws URISyntaxException {
        return this.getConnectionURI(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxwellMysqlConfig that = (MaxwellMysqlConfig)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.database, that.database) && Objects.equals(this.user, that.user) && Objects.equals(this.password, that.password) && this.sslMode == that.sslMode && Objects.equals(this.jdbcOptions, that.jdbcOptions) && Objects.equals(this.connectTimeoutMS, that.connectTimeoutMS);
    }

    public boolean sameServerAs(MaxwellMysqlConfig other) {
        return Objects.equals(this.host, other.host) && Objects.equals(this.port, other.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.database, this.user, this.password, this.sslMode, this.jdbcOptions, this.connectTimeoutMS);
    }
}

