/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.bootstrap;

import com.zendesk.maxwell.bootstrap.BootstrapTask;
import com.zendesk.maxwell.bootstrap.SynchronousBootstrapper;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.row.RowMapBuffer;
import com.zendesk.maxwell.util.ConnectionPool;
import com.zendesk.maxwell.util.RunLoopProcess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapController
extends RunLoopProcess {
    static final Logger LOGGER = LoggerFactory.getLogger(BootstrapController.class);
    private final long MAX_TX_ELEMENTS = 10000L;
    private final ConnectionPool maxwellConnectionPool;
    private final SynchronousBootstrapper bootstrapper;
    private final AbstractProducer producer;
    private final String clientID;
    private final boolean syncMode;
    private Long currentSchemaID;
    private Object bootstrapMutex = new Object();
    private Object completionMutex = new Object();
    private BootstrapTask activeTask;
    private RowMapBuffer skippedRows = new RowMapBuffer(10000L);

    public BootstrapController(ConnectionPool maxwellConnectionPool, AbstractProducer producer, SynchronousBootstrapper bootstrapper, String clientID, boolean syncMode, Long currentSchemaID) {
        this.maxwellConnectionPool = maxwellConnectionPool;
        this.producer = producer;
        this.bootstrapper = bootstrapper;
        this.clientID = clientID;
        this.syncMode = syncMode;
        this.currentSchemaID = currentSchemaID;
    }

    @Override
    protected void work() throws Exception {
        try {
            this.doWork();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (SQLException e) {
            LOGGER.error("got SQLException trying to bootstrap", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws Exception {
        List<BootstrapTask> tasks = this.getIncompleteTasks();
        Object object = this.bootstrapMutex;
        synchronized (object) {
            for (BootstrapTask task : tasks) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("starting bootstrap task: {}", (Object)task.logString());
                }
                Object object2 = this.completionMutex;
                synchronized (object2) {
                    this.activeTask = task;
                }
                this.bootstrapper.startBootstrap(task, this.producer, this.getCurrentSchemaID());
                object2 = this.completionMutex;
                synchronized (object2) {
                    this.pushSkippedRows();
                    this.activeTask = null;
                }
            }
        }
        Thread.sleep(1000L);
    }

    private synchronized Long getCurrentSchemaID() {
        return this.currentSchemaID;
    }

    public synchronized void setCurrentSchemaID(Long schemaID) {
        this.currentSchemaID = schemaID;
    }

    private List<BootstrapTask> getIncompleteTasks() throws SQLException {
        ArrayList<BootstrapTask> list = new ArrayList<BootstrapTask>();
        try (Connection cx = this.maxwellConnectionPool.getConnection();
             PreparedStatement s = cx.prepareStatement("select * from bootstrap where is_complete = 0 and client_id = ? and (started_at is null or started_at <= now()) order by isnull(started_at), started_at asc, id asc");){
            s.setString(1, this.clientID);
            try (ResultSet rs = s.executeQuery();){
                while (rs.next()) {
                    list.add(BootstrapTask.valueOf(rs));
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldSkip(RowMap row) throws IOException {
        if (this.syncMode) {
            Object object = this.bootstrapMutex;
            synchronized (object) {
                return false;
            }
        }
        Object object = this.completionMutex;
        synchronized (object) {
            if (this.activeTask == null) {
                return false;
            }
            if (this.activeTask.matches(row)) {
                this.skippedRows.add(row);
                return true;
            }
            return false;
        }
    }

    private void pushSkippedRows() throws Exception {
        this.skippedRows.flushToDisk();
        while (this.skippedRows.size() > 0L) {
            RowMap row = this.skippedRows.removeFirst();
            this.producer.push(row);
        }
    }
}

