/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zendesk.maxwell.monitoring.DiagnosticHealthCheckModule;
import com.zendesk.maxwell.monitoring.MaxwellDiagnostic;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticContext;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiagnosticHealthCheck
extends HttpServlet {
    private static final String CONTENT_TYPE = "text/json";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";
    private final MaxwellDiagnosticContext diagnosticContext;
    protected transient ObjectMapper mapper;

    public DiagnosticHealthCheck(MaxwellDiagnosticContext diagnosticContext) {
        this.diagnosticContext = diagnosticContext;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mapper = new ObjectMapper().registerModule((Module)new DiagnosticHealthCheckModule());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader(CACHE_CONTROL, NO_CACHE);
        resp.setContentType(CONTENT_TYPE);
        Map<MaxwellDiagnostic, CompletableFuture> futureChecks = this.diagnosticContext.diagnostics.stream().collect(Collectors.toMap(diagnostic -> diagnostic, MaxwellDiagnostic::check));
        List<MaxwellDiagnosticResult.Check> checks = futureChecks.entrySet().stream().map(future -> {
            CompletableFuture futureCheck = (CompletableFuture)future.getValue();
            try {
                return (MaxwellDiagnosticResult.Check)futureCheck.get(this.diagnosticContext.config.timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                futureCheck.cancel(true);
                MaxwellDiagnostic diagnostic = (MaxwellDiagnostic)future.getKey();
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("message", "check did not return after " + this.diagnosticContext.config.timeout + " ms");
                return new MaxwellDiagnosticResult.Check(diagnostic, false, info);
            }
        }).collect(Collectors.toList());
        MaxwellDiagnosticResult result = new MaxwellDiagnosticResult(checks);
        if (result.isSuccess()) {
            resp.setStatus(200);
        } else if (result.isMandatoryFailed()) {
            resp.setStatus(503);
        } else {
            resp.setStatus(299);
        }
        try (PrintWriter output = resp.getWriter();){
            this.mapper.writer().writeValue((Writer)output, (Object)result);
        }
    }
}

