/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.google.cloud.bigquery.storage.v1.TableName;
import com.google.protobuf.Descriptors;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.producer.MaxwellBigQueryProducerWorker;
import com.zendesk.maxwell.row.RowMap;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;

public class MaxwellBigQueryProducer
extends AbstractProducer {
    private final ArrayBlockingQueue<RowMap> queue = new ArrayBlockingQueue(100);
    private final MaxwellBigQueryProducerWorker worker;

    public MaxwellBigQueryProducer(MaxwellContext context, String bigQueryProjectId, String bigQueryDataset, String bigQueryTable) throws IOException {
        super(context);
        this.worker = new MaxwellBigQueryProducerWorker(context, this.queue, bigQueryProjectId, bigQueryDataset, bigQueryTable);
        TableName table = TableName.of((String)bigQueryProjectId, (String)bigQueryDataset, (String)bigQueryTable);
        try {
            this.worker.initialize(table);
        }
        catch (Descriptors.DescriptorValidationException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Thread thread = new Thread((Runnable)this.worker, "maxwell-bigquery-worker");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void push(RowMap r) throws Exception {
        this.queue.put(r);
    }
}

