/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.TopicName;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.monitoring.Metrics;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.PubsubCallback;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.schema.ddl.DDLMap;
import com.zendesk.maxwell.util.StoppableTask;
import com.zendesk.maxwell.util.StoppableTaskState;
import com.zendesk.maxwell.util.TopicInterpolator;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MaxwellPubsubProducerWorker
extends AbstractAsyncProducer
implements Runnable,
StoppableTask {
    static final Logger LOGGER = LoggerFactory.getLogger(MaxwellPubsubProducerWorker.class);
    private final String projectId;
    private Publisher pubsub;
    private final ProjectTopicName topic;
    private final ProjectTopicName ddlTopic;
    private Publisher ddlPubsub;
    private final TopicInterpolator messageOrderingKeyInterpolator;
    private final ArrayBlockingQueue<RowMap> queue;
    private Thread thread;
    private StoppableTaskState taskState;

    public MaxwellPubsubProducerWorker(MaxwellContext context, String pubsubProjectId, String pubsubTopic, String ddlPubsubTopic, String pubsubMessageOrderingKey, String pubsubEmulator, ArrayBlockingQueue<RowMap> queue) throws IOException {
        super(context);
        BatchingSettings batchingSettings = BatchingSettings.newBuilder().setElementCountThreshold(context.getConfig().pubsubMessageCountBatchSize).setRequestByteThreshold(context.getConfig().pubsubRequestBytesThreshold).setDelayThreshold(context.getConfig().pubsubPublishDelayThreshold).build();
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRetryDelay(context.getConfig().pubsubRetryDelay).setRetryDelayMultiplier((double)context.getConfig().pubsubRetryDelayMultiplier.floatValue()).setMaxRetryDelay(context.getConfig().pubsubMaxRetryDelay).setInitialRpcTimeout(context.getConfig().pubsubInitialRpcTimeout).setRpcTimeoutMultiplier((double)context.getConfig().pubsubRpcTimeoutMultiplier.floatValue()).setMaxRpcTimeout(context.getConfig().pubsubMaxRpcTimeout).setTotalTimeout(context.getConfig().pubsubTotalTimeout).build();
        this.projectId = pubsubProjectId;
        this.topic = ProjectTopicName.of((String)pubsubProjectId, (String)pubsubTopic);
        Publisher.Builder pubsubBuilder = Publisher.newBuilder((TopicName)this.topic).setEnableMessageOrdering(pubsubMessageOrderingKey != null).setBatchingSettings(batchingSettings).setRetrySettings(retrySettings);
        if (pubsubEmulator != null) {
            ManagedChannel channel = ManagedChannelBuilder.forTarget((String)pubsubEmulator).usePlaintext().build();
            FixedTransportChannelProvider channelProvider = FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
            NoCredentialsProvider credentialsProvider = NoCredentialsProvider.create();
            pubsubBuilder.setCredentialsProvider((CredentialsProvider)credentialsProvider).setChannelProvider((TransportChannelProvider)channelProvider);
        }
        this.pubsub = pubsubBuilder.build();
        if (context.getConfig().outputConfig.outputDDL && ddlPubsubTopic != pubsubTopic) {
            this.ddlTopic = ProjectTopicName.of((String)pubsubProjectId, (String)ddlPubsubTopic);
            this.ddlPubsub = Publisher.newBuilder((TopicName)this.ddlTopic).build();
        } else {
            this.ddlTopic = this.topic;
            this.ddlPubsub = this.pubsub;
        }
        this.messageOrderingKeyInterpolator = pubsubMessageOrderingKey == null ? null : new TopicInterpolator(pubsubMessageOrderingKey);
        Metrics metrics = context.getMetrics();
        this.queue = queue;
        this.taskState = new StoppableTaskState("MaxwellPubsubProducerWorker");
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        try {
            while (true) {
                RowMap row = this.queue.take();
                if (!this.taskState.isRunning()) {
                    this.taskState.stopped();
                    return;
                }
                this.push(row);
            }
        }
        catch (Exception e) {
            this.taskState.stopped();
            this.context.terminate(e);
            return;
        }
    }

    @Override
    public void sendAsync(RowMap r, AbstractAsyncProducer.CallbackCompleter cc) throws Exception {
        String message = r.toJSON(this.outputConfig);
        ByteString data = ByteString.copyFromUtf8((String)message);
        PubsubMessage.Builder pubsubMessageBuilder = PubsubMessage.newBuilder().setData(data);
        if (this.messageOrderingKeyInterpolator != null) {
            String orderingKey = this.messageOrderingKeyInterpolator.generateFromRowMapAndCleanUpIllegalCharacters(r);
            pubsubMessageBuilder = pubsubMessageBuilder.setOrderingKey(orderingKey);
            LOGGER.debug("using message ordering key {}", (Object)orderingKey);
        } else {
            LOGGER.debug("using no message ordering key");
        }
        PubsubMessage pubsubMessage = pubsubMessageBuilder.build();
        if (r instanceof DDLMap) {
            ApiFuture apiFuture = this.ddlPubsub.publish(pubsubMessage);
            PubsubCallback callback = new PubsubCallback(cc, r.getNextPosition(), message, this.succeededMessageCount, this.failedMessageCount, this.succeededMessageMeter, this.failedMessageMeter, this.context);
            ApiFutures.addCallback((ApiFuture)apiFuture, (ApiFutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        } else {
            ApiFuture apiFuture = this.pubsub.publish(pubsubMessage);
            PubsubCallback callback = new PubsubCallback(cc, r.getNextPosition(), message, this.succeededMessageCount, this.failedMessageCount, this.succeededMessageMeter, this.failedMessageMeter, this.context);
            ApiFutures.addCallback((ApiFuture)apiFuture, (ApiFutureCallback)callback, (Executor)MoreExecutors.directExecutor());
        }
    }

    @Override
    public void requestStop() throws Exception {
        this.taskState.requestStop();
        this.pubsub.shutdown();
        if (this.ddlPubsub != null) {
            this.ddlPubsub.shutdown();
        }
    }

    @Override
    public void awaitStop(Long timeout) throws TimeoutException {
        this.taskState.awaitStop(this.thread, timeout);
    }

    @Override
    public StoppableTask getStoppableTask() {
        return this;
    }
}

