/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractProducer;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.util.StoppableTask;
import com.zendesk.maxwell.util.TopicInterpolator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class MaxwellRedisProducer
extends AbstractProducer
implements StoppableTask {
    private static final Logger logger = LoggerFactory.getLogger(MaxwellRedisProducer.class);
    private final String channel;
    private final String redisType;
    private final TopicInterpolator topicInterpolator;
    private static JedisPoolAbstract jedisPool;

    @Deprecated
    public MaxwellRedisProducer(MaxwellContext context, String redisPubChannel, String redisListKey, String redisType) {
        this(context);
    }

    public MaxwellRedisProducer(MaxwellContext context) {
        super(context);
        this.channel = context.getConfig().redisKey;
        this.topicInterpolator = new TopicInterpolator(this.channel);
        this.redisType = context.getConfig().redisType;
        String redisSentinelName = context.getConfig().redisSentinelMasterName;
        jedisPool = redisSentinelName != null ? new JedisSentinelPool(context.getConfig().redisSentinelMasterName, this.getRedisSentinels(context.getConfig().redisSentinels), (GenericObjectPoolConfig)this.createRedisPoolConfig(), 2000, context.getConfig().redisAuth, context.getConfig().redisDatabase) : new JedisPool((GenericObjectPoolConfig)this.createRedisPoolConfig(), context.getConfig().redisHost, context.getConfig().redisPort, 2000, context.getConfig().redisAuth, context.getConfig().redisDatabase);
    }

    private Set<String> getRedisSentinels(String redisSentinels) {
        return new HashSet<String>(Arrays.asList(redisSentinels.split(",")));
    }

    private JedisPoolConfig createRedisPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(2);
        poolConfig.setMaxIdle(2);
        poolConfig.setMinIdle(0);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setBlockWhenExhausted(true);
        return poolConfig;
    }

    private Jedis getJedisResource() {
        return (Jedis)jedisPool.getResource();
    }

    /*
     * Unable to fully structure code
     */
    private void sendToRedis(RowMap msg) throws Exception {
        messageStr = msg.toJSON(this.outputConfig);
        channel = this.topicInterpolator.generateFromRowMap(msg);
        jedis = this.getJedisResource();
        try {
            var5_5 = this.redisType;
            var6_8 = -1;
            switch (var5_5.hashCode()) {
                case 103192966: {
                    if (!var5_5.equals("lpush")) break;
                    var6_8 = 0;
                    break;
                }
                case 108734092: {
                    if (!var5_5.equals("rpush")) break;
                    var6_8 = 1;
                    break;
                }
                case 3671337: {
                    if (!var5_5.equals("xadd")) break;
                    var6_8 = 2;
                    break;
                }
                case -977416669: {
                    if (!var5_5.equals("pubsub")) break;
                    var6_8 = 3;
                }
            }
            switch (var6_8) {
                case 0: {
                    jedis.lpush(channel, new String[]{messageStr});
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 1: {
                    jedis.rpush(channel, new String[]{messageStr});
                    ** break;
lbl33:
                    // 1 sources

                    break;
                }
                case 2: {
                    message = new HashMap<String, String>();
                    jsonKey = this.context.getConfig().redisStreamJsonKey;
                    if (jsonKey == null) {
                        throw new IllegalArgumentException("Stream requires key name for serialized JSON value");
                    }
                    message.put(jsonKey, messageStr);
                    jedis.xadd(channel, StreamEntryID.NEW_ENTRY, message);
                    ** break;
lbl44:
                    // 1 sources

                    break;
                }
                default: {
                    jedis.publish(channel, messageStr);
                    break;
                }
            }
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        if (MaxwellRedisProducer.logger.isDebugEnabled()) {
            var4_4 = this.redisType;
            var5_7 = -1;
            switch (var4_4.hashCode()) {
                case 103192966: {
                    if (!var4_4.equals("lpush")) break;
                    var5_7 = 0;
                    break;
                }
                case 108734092: {
                    if (!var4_4.equals("rpush")) break;
                    var5_7 = 1;
                    break;
                }
                case 3671337: {
                    if (!var4_4.equals("xadd")) break;
                    var5_7 = 2;
                    break;
                }
                case -977416669: {
                    if (!var4_4.equals("pubsub")) break;
                    var5_7 = 3;
                }
            }
            switch (var5_7) {
                case 0: {
                    MaxwellRedisProducer.logger.debug("->  queue (left):{}, msg:{}", (Object)channel, (Object)msg);
                    break;
                }
                case 1: {
                    MaxwellRedisProducer.logger.debug("->  queue (right):{}, msg:{}", (Object)channel, (Object)msg);
                    break;
                }
                case 2: {
                    MaxwellRedisProducer.logger.debug("->  stream:{}, msg:{}", (Object)channel, (Object)msg);
                    break;
                }
                default: {
                    MaxwellRedisProducer.logger.debug("->  channel:{}, msg:{}", (Object)channel, (Object)msg);
                }
            }
        }
    }

    @Override
    public void push(RowMap r) throws Exception {
        if (!r.shouldOutput(this.outputConfig)) {
            this.context.setPosition(r.getNextPosition());
            return;
        }
        boolean sentToRedis = false;
        for (int cxErrors = 0; cxErrors < 2; ++cxErrors) {
            try {
                this.sendToRedis(r);
                sentToRedis = true;
                break;
            }
            catch (Exception e) {
                if (e instanceof JedisConnectionException) {
                    logger.warn("lost connection to server, will try again with another connection from pool", (Throwable)e);
                    continue;
                }
                logger.error("Exception during put", (Throwable)e);
                if (this.context.getConfig().ignoreProducerError) continue;
                throw new RuntimeException(e);
            }
        }
        if (sentToRedis) {
            this.succeededMessageCount.inc();
            this.succeededMessageMeter.mark();
        } else {
            this.failedMessageCount.inc();
            this.failedMessageMeter.mark();
        }
        if (r.isTXCommit()) {
            this.context.setPosition(r.getNextPosition());
        }
    }

    @Override
    public void requestStop() {
        jedisPool.close();
    }

    @Override
    public void awaitStop(Long timeout) {
    }

    @Override
    public StoppableTask getStoppableTask() {
        return this;
    }
}

