/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.zendesk.maxwell.row.EncryptingJsonGenerator;
import com.zendesk.maxwell.row.PlaintextJsonGenerator;
import com.zendesk.maxwell.row.RawJSONString;
import com.zendesk.maxwell.scripting.Scripting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.script.ScriptException;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxwellJson {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaxwellJson.class);
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final JsonGenerator jsonGenerator = jsonFactory.createGenerator((OutputStream)this.buffer);
    private final PlaintextJsonGenerator plaintextGenerator;
    private final EncryptingJsonGenerator encryptingGenerator;
    private static final ThreadLocal<MaxwellJson> instance = ThreadLocal.withInitial(() -> {
        try {
            return new MaxwellJson();
        }
        catch (IOException e) {
            LOGGER.error("error initializing MaxwellJson", (Throwable)e);
            return null;
        }
    });

    private MaxwellJson() throws IOException {
        this.jsonGenerator.setRootValueSeparator(null);
        this.plaintextGenerator = new PlaintextJsonGenerator(this.jsonGenerator);
        this.encryptingGenerator = new EncryptingJsonGenerator(this.jsonGenerator, jsonFactory);
    }

    public static MaxwellJson getInstance() {
        return instance.get();
    }

    public PlaintextJsonGenerator getPlaintextGenerator() {
        return this.plaintextGenerator;
    }

    public EncryptingJsonGenerator getEncryptingGenerator() {
        return this.encryptingGenerator;
    }

    public JsonGenerator reset() throws IOException {
        this.buffer.reset();
        return this.jsonGenerator;
    }

    public String consume() throws IOException {
        this.jsonGenerator.flush();
        String s = this.buffer.toString();
        this.buffer.reset();
        return s;
    }

    public static void writeValueToJSON(JsonGenerator g, boolean includeNullField, String key, Object value) throws IOException {
        if (value == null && !includeNullField) {
            return;
        }
        if (value instanceof ScriptObjectMirror) {
            try {
                String json = Scripting.stringify((ScriptObjectMirror)value);
                MaxwellJson.writeValueToJSON(g, includeNullField, key, new RawJSONString(json));
            }
            catch (ScriptException e) {
                LOGGER.error("error stringifying json object:", (Throwable)e);
            }
        } else if (value instanceof List) {
            List stringList = (List)value;
            g.writeArrayFieldStart(key);
            for (Object s : stringList) {
                g.writeObject(s);
            }
            g.writeEndArray();
        } else if (value instanceof RawJSONString) {
            g.writeFieldName(key);
            g.writeRawValue(((RawJSONString)value).json);
        } else {
            g.writeObjectField(key, value);
        }
    }
}

