/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.row;

import com.fasterxml.jackson.core.JsonGenerator;
import com.zendesk.maxwell.row.MaxwellJson;
import com.zendesk.maxwell.row.RowMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class RowIdentity
implements Serializable {
    private final String database;
    private final String table;
    private final String rowType;
    private final List<Pair<String, Object>> primaryKeyColumns;

    public RowIdentity(String database, String table, String rowType, List<Pair<String, Object>> primaryKeyColumns) {
        this.database = database;
        this.table = table;
        this.primaryKeyColumns = primaryKeyColumns;
        this.rowType = rowType;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String toKeyJson(RowMap.KeyFormat keyFormat) throws IOException {
        MaxwellJson json = MaxwellJson.getInstance();
        JsonGenerator g = json.reset();
        if (keyFormat == RowMap.KeyFormat.HASH) {
            this.startCommonHashFields(g);
            if (this.primaryKeyColumns.isEmpty()) {
                g.writeStringField("_uuid", UUID.randomUUID().toString());
            } else {
                for (Map.Entry entry : this.primaryKeyColumns) {
                    MaxwellJson.writeValueToJSON(g, true, "pk." + ((String)entry.getKey()).toLowerCase(), entry.getValue());
                }
            }
            g.writeEndObject();
        } else {
            g.writeStartArray();
            g.writeString(this.database);
            g.writeString(this.table);
            g.writeStartArray();
            for (Map.Entry entry : this.primaryKeyColumns) {
                g.writeStartObject();
                MaxwellJson.writeValueToJSON(g, true, ((String)entry.getKey()).toLowerCase(), entry.getValue());
                g.writeEndObject();
            }
            g.writeEndArray();
            g.writeEndArray();
        }
        return json.consume();
    }

    public String toFallbackValueWithReason(String reason) throws IOException {
        MaxwellJson json = MaxwellJson.getInstance();
        JsonGenerator g = json.reset();
        this.startCommonHashFields(g);
        g.writeStringField("type", this.rowType);
        g.writeStringField("reason", reason);
        g.writeObjectFieldStart("data");
        for (Map.Entry entry : this.primaryKeyColumns) {
            this.writePrimaryKey(g, entry);
        }
        g.writeEndObject();
        g.writeEndObject();
        return json.consume();
    }

    public String toConcatString() {
        if (this.primaryKeyColumns.isEmpty()) {
            return this.database + this.table;
        }
        StringBuilder keys = new StringBuilder();
        for (Map.Entry entry : this.primaryKeyColumns) {
            Object pkValue = entry.getValue();
            if (pkValue == null) continue;
            keys.append(pkValue.toString());
        }
        if (keys.length() == 0) {
            return "None";
        }
        return keys.toString();
    }

    public String toString() {
        return this.database + ":" + this.table + ":" + this.primaryKeyColumns;
    }

    private void startCommonHashFields(JsonGenerator g) throws IOException {
        g.writeStartObject();
        g.writeStringField("database", this.database);
        g.writeStringField("table", this.table);
    }

    private void writePrimaryKey(JsonGenerator g, String jsonKey, Object value) throws IOException {
        MaxwellJson.writeValueToJSON(g, true, jsonKey, value);
    }

    private void writePrimaryKey(JsonGenerator g, Map.Entry<String, Object> pk) throws IOException {
        this.writePrimaryKey(g, pk.getKey(), pk.getValue());
    }
}

