/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import java.util.ArrayList;
import java.util.List;

public class Database {
    private final String name;
    private final List<Table> tableList;
    private String charset;
    private CaseSensitivity sensitivity;

    public Database(String name, List<Table> tables, String charset) {
        this.name = name;
        this.tableList = tables == null ? new ArrayList<Table>() : tables;
        this.charset = charset;
    }

    public Database(String name, String charset) {
        this(name, null, charset);
    }

    public List<String> getTableNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Table t : this.tableList) {
            names.add(t.getName());
        }
        return names;
    }

    private boolean compareTableNames(String a, String b) {
        if (this.sensitivity == CaseSensitivity.CASE_SENSITIVE) {
            return a.equals(b);
        }
        return a.toLowerCase().equals(b.toLowerCase());
    }

    public Table findTable(String name) {
        for (Table t : this.tableList) {
            if (!this.compareTableNames(name, t.getName())) continue;
            return t;
        }
        return null;
    }

    public Table findTableOrThrow(String table) throws InvalidSchemaError {
        Table t = this.findTable(table);
        if (t == null) {
            throw new InvalidSchemaError("Couldn't find table '" + table + "' in database " + this.name);
        }
        return t;
    }

    public boolean hasTable(String name) {
        return this.findTable(name) != null;
    }

    public void removeTable(String name) {
        Table t = this.findTable(name);
        if (t != null) {
            this.tableList.remove(t);
        }
    }

    public Database copy() {
        Database d = new Database(this.name, this.charset);
        for (Table t : this.tableList) {
            d.addTable(t.copy());
        }
        return d;
    }

    private void diffTableList(List<String> diffs, Database a, Database b, String nameA, String nameB, boolean recurse) {
        for (Table t : a.getTableList()) {
            Table other = b.findTable(t.getName());
            if (other == null) {
                diffs.add("database " + a.getName() + " did not contain table " + t.getName() + " in " + nameB);
                continue;
            }
            if (!recurse) continue;
            t.diff(diffs, other, nameA, nameB);
        }
    }

    public void diff(List<String> diffs, Database other, String nameA, String nameB) {
        if (!Schema.charsetEquals(this.charset, other.getCharset())) {
            diffs.add("-- Database " + this.getName() + " had different charset: " + this.getCharset() + " in " + nameA + ", " + other.getCharset() + " in " + nameB);
        }
        this.diffTableList(diffs, this, other, nameA, nameB, true);
        this.diffTableList(diffs, other, this, nameB, nameA, false);
    }

    public String getCharset() {
        if (this.charset == null) {
            return "";
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getName() {
        return this.name;
    }

    public List<Table> getTableList() {
        return this.tableList;
    }

    public void addTable(Table table) {
        table.setDatabase(this.name);
        this.tableList.add(table);
    }

    public Table buildTable(String name, String charset, List<ColumnDef> list, List<String> pks) {
        if (charset == null) {
            charset = this.getCharset();
        }
        if (this.sensitivity == CaseSensitivity.CONVERT_TO_LOWER) {
            name = name.toLowerCase();
        }
        Table t = new Table(this.name, name, charset, list, pks);
        this.tableList.add(t);
        return t;
    }

    public Table buildTable(String name, String charset) {
        return this.buildTable(name, charset, new ArrayList<ColumnDef>(), null);
    }

    public void setSensitivity(CaseSensitivity sensitivity) {
        this.sensitivity = sensitivity;
    }
}

