/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.TableColumnList;
import com.zendesk.maxwell.schema.columndef.BigIntColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.EnumeratedColumnDef;
import com.zendesk.maxwell.schema.columndef.IntColumnDef;
import com.zendesk.maxwell.schema.columndef.StringColumnDef;
import com.zendesk.maxwell.schema.ddl.ColumnPosition;
import com.zendesk.maxwell.schema.ddl.DeferredPositionUpdate;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Table {
    public String database;
    @JsonProperty(value="table")
    public String name;
    private TableColumnList columns;
    public String charset;
    private List<String> pkColumnNames;
    private List<String> normalizedPKColumnNames;
    @JsonIgnore
    public int pkIndex;

    public Table() {
    }

    public Table(String database, String name, String charset, List<ColumnDef> list, List<String> pks) {
        this.database = database.intern();
        this.name = name.intern();
        this.charset = charset;
        if (this.charset != null) {
            this.charset = this.charset.intern();
        }
        this.setColumnList(list);
        if (pks == null) {
            pks = new ArrayList<String>();
        }
        this.setPKList(pks);
    }

    @JsonProperty(value="table")
    public void setTable(String name) {
        this.name = name.intern();
    }

    @JsonProperty(value="columns")
    public List<ColumnDef> getColumnList() {
        return this.columns.getList();
    }

    @JsonIgnore
    public Set<String> getColumnNames() {
        return this.columns.columnNames();
    }

    @JsonProperty(value="columns")
    public void setColumnList(List<ColumnDef> list) {
        this.columns = new TableColumnList(list);
    }

    @JsonIgnore
    public List<StringColumnDef> getStringColumns() {
        ArrayList<StringColumnDef> list = new ArrayList<StringColumnDef>();
        for (ColumnDef c : this.columns) {
            if (!(c instanceof StringColumnDef)) continue;
            list.add((StringColumnDef)c);
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public short findColumnIndex(String name) {
        return (short)this.columns.indexOf(name);
    }

    public ColumnDef findColumn(String name) {
        return this.columns.findByName(name);
    }

    public ColumnDef findColumn(int index) {
        return this.columns.get(index);
    }

    @JsonIgnore
    public int getPKIndex() {
        return this.pkIndex;
    }

    public String getDatabase() {
        return this.database;
    }

    public Table copy() {
        ArrayList<ColumnDef> list = new ArrayList<ColumnDef>();
        ArrayList<String> pkList = new ArrayList<String>();
        for (ColumnDef c : this.columns) {
            list.add(c);
        }
        for (String s : this.pkColumnNames) {
            pkList.add(s);
        }
        return new Table(this.database, this.name, this.charset, list, pkList);
    }

    public void rename(String tableName) {
        this.name = tableName;
    }

    private void diffColumnList(List<String> diffs, Table a, Table b, String nameA, String nameB) {
        for (ColumnDef column : a.getColumnList()) {
            boolean signedB;
            boolean signedA;
            ColumnDef other = b.findColumn(column.getName());
            if (other == null) {
                diffs.add(b.fullName() + " is missing column " + column.getName() + " in " + nameB);
                continue;
            }
            String colName = a.fullName() + ".`" + column.getName() + "` ";
            if (!column.getType().equals(other.getType())) {
                diffs.add(colName + "has a type mismatch, " + column.getType() + " vs " + other.getType() + " in " + nameB);
                return;
            }
            if (column.getPos() != other.getPos()) {
                diffs.add(colName + "has a position mismatch, " + column.getPos() + " vs " + other.getPos() + " in " + nameB);
            }
            if (column instanceof EnumeratedColumnDef) {
                EnumeratedColumnDef enumA = (EnumeratedColumnDef)column;
                EnumeratedColumnDef enumB = (EnumeratedColumnDef)other;
                if (!enumA.getEnumValues().equals(enumB.getEnumValues())) {
                    diffs.add(colName + "has an enum value mismatch, " + StringUtils.join(enumA.getEnumValues(), (String)",") + " vs " + StringUtils.join(enumB.getEnumValues(), (String)",") + " in " + nameB);
                }
            }
            if (column instanceof StringColumnDef) {
                StringColumnDef stringA = (StringColumnDef)column;
                StringColumnDef stringB = (StringColumnDef)other;
                if (!Schema.charsetEquals(stringA.getCharset(), stringB.getCharset())) {
                    diffs.add(colName + "has an charset mismatch, '" + stringA.getCharset() + "' vs '" + stringB.getCharset() + "' in " + nameB);
                }
            }
            if (column instanceof IntColumnDef && (signedA = ((IntColumnDef)column).isSigned()) != (signedB = ((IntColumnDef)other).isSigned())) {
                diffs.add(colName + "has a signedness mismatch, '" + signedA + "' vs '" + signedB + "' in " + nameB);
            }
            if (!(column instanceof BigIntColumnDef) || (signedA = ((BigIntColumnDef)column).isSigned()) == (signedB = ((BigIntColumnDef)other).isSigned())) continue;
            diffs.add(colName + "has a signedness mismatch, '" + signedA + "' vs '" + signedB + "' in " + nameB);
        }
    }

    public String fullName() {
        return "`" + this.database + "`." + this.name + "`";
    }

    public void diff(List<String> diffs, Table other, String nameA, String nameB) {
        if (!Schema.charsetEquals(this.charset, other.getCharset())) {
            diffs.add(this.fullName() + " differs in charset: " + nameA + " is " + this.getCharset() + " but " + nameB + " is " + other.getCharset());
        }
        if (!this.getPKString().equals(other.getPKString())) {
            diffs.add(this.fullName() + " differs in PKs: " + nameA + " is " + this.getPKString() + " but " + nameB + " is " + other.getPKString());
        }
        if (!this.getName().equals(other.getName())) {
            diffs.add(this.fullName() + " differs in name: " + nameA + " is " + this.getName() + " but " + nameB + " is " + other.getName());
        }
        this.diffColumnList(diffs, this, other, nameA, nameB);
        this.diffColumnList(diffs, other, this, nameB, nameA);
    }

    public void setDefaultColumnCharsets() {
        String newCharset = this.getCharset();
        for (StringColumnDef c : this.getStringColumns()) {
            int index = c.getPos();
            this.columns.replace(index, c.withDefaultCharset(newCharset));
        }
    }

    public void addColumn(int index, ColumnDef definition) {
        this.columns.add(index, definition);
    }

    public void addColumn(ColumnDef definition) {
        this.columns.add(this.columns.size(), definition);
    }

    public void addColumns(List<ColumnDef> definitions) {
        this.columns.addAll(definitions);
    }

    public void removeColumn(int idx) {
        ColumnDef toRemove = this.columns.get(idx);
        this.removePKColumn(toRemove.getName());
        this.columns.remove(idx);
    }

    public void renameColumn(int idx, String name) throws InvalidSchemaError {
        ColumnDef oldColumn = this.columns.get(idx);
        this.renamePKColumn(oldColumn.getName(), name);
        ColumnDef column = this.columns.get(idx).withName(name);
        this.columns.replace(idx, column);
    }

    public void replaceColumn(int idx, ColumnDef definition) throws InvalidSchemaError {
        this.columns.replace(idx, definition);
    }

    public void changeColumn(int idx, ColumnPosition position, ColumnDef definition, List<DeferredPositionUpdate> deferred) throws InvalidSchemaError {
        ColumnDef oldColumn = this.columns.get(idx);
        this.renamePKColumn(oldColumn.getName(), definition.getName());
        this.columns.remove(idx);
        int index = position.index(this, idx);
        if (index == -999) {
            deferred.add(new DeferredPositionUpdate(definition.getName(), position));
            index = 0;
        }
        this.columns.add(index, definition);
    }

    public void moveColumn(String name, ColumnPosition position) throws InvalidSchemaError {
        int idx = this.columns.indexOf(name);
        ColumnDef def = this.columns.remove(idx);
        int newIndex = position.index(this, idx);
        if (newIndex == -999) {
            throw new InvalidSchemaError("Couldn't find column " + position.afterColumn + " to place after");
        }
        this.columns.add(newIndex, def);
    }

    public void setDatabase(String database) {
        this.database = database.intern();
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
        if (this.charset != null) {
            this.charset = charset.intern();
        }
    }

    @JsonProperty(value="primary-key")
    public List<String> getPKList() {
        return this.normalizedColumnNames();
    }

    @JsonIgnore
    public String getPKString() {
        if (this.pkColumnNames != null) {
            return StringUtils.join(this.pkColumnNames.iterator(), (String)",");
        }
        return null;
    }

    @JsonProperty(value="primary-key")
    public synchronized void setPKList(List<String> pkColumnNames) {
        this.pkColumnNames = pkColumnNames.stream().map(n -> n.intern()).collect(Collectors.toList());
        this.normalizedPKColumnNames = null;
    }

    private synchronized void removePKColumn(String name) {
        int pkIndex = this.getPKList().indexOf(name);
        if (pkIndex != -1) {
            this.pkColumnNames.remove(pkIndex);
            this.normalizedPKColumnNames = null;
        }
    }

    private synchronized void renamePKColumn(String oldName, String newName) {
        int pkIndex = this.getPKList().indexOf(oldName);
        if (pkIndex != -1) {
            this.pkColumnNames.set(pkIndex, newName);
            this.normalizedPKColumnNames = null;
        }
    }

    private synchronized List<String> normalizedColumnNames() {
        if (this.normalizedPKColumnNames == null) {
            this.normalizedPKColumnNames = new ArrayList<String>(this.pkColumnNames.size());
            for (String name : this.pkColumnNames) {
                ColumnDef cd = this.findColumn(name);
                if (cd == null) {
                    throw new RuntimeException("Couldn't find column for primary-key: " + name);
                }
                this.normalizedPKColumnNames.add(cd.getName());
            }
        }
        return this.normalizedPKColumnNames;
    }
}

