/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.zendesk.maxwell.schema.columndef.BigIntColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.columndef.ColumnDefWithLength;
import com.zendesk.maxwell.schema.columndef.EnumeratedColumnDef;
import com.zendesk.maxwell.schema.columndef.IntColumnDef;
import com.zendesk.maxwell.schema.columndef.StringColumnDef;
import java.io.IOException;

public class ColumnDefSerializer
extends JsonSerializer<ColumnDef> {
    public void serialize(ColumnDef def, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Long columnLength;
        jgen.writeStartObject();
        jgen.writeStringField("type", def.getType());
        jgen.writeStringField("name", def.getName());
        if (def instanceof StringColumnDef) {
            jgen.writeStringField("charset", ((StringColumnDef)def).getCharset());
        } else if (def instanceof IntColumnDef) {
            jgen.writeBooleanField("signed", ((IntColumnDef)def).isSigned());
        } else if (def instanceof BigIntColumnDef) {
            jgen.writeBooleanField("signed", ((BigIntColumnDef)def).isSigned());
        } else if (def instanceof EnumeratedColumnDef) {
            jgen.writeArrayFieldStart("enum-values");
            for (String s : ((EnumeratedColumnDef)def).getEnumValues()) {
                jgen.writeString(s);
            }
            jgen.writeEndArray();
        } else if (def instanceof ColumnDefWithLength && (columnLength = ((ColumnDefWithLength)def).getColumnLength()) != null) {
            jgen.writeNumberField("column-length", columnLength.longValue());
        }
        jgen.writeEndObject();
    }
}

