/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.columndef;

import com.zendesk.maxwell.producer.MaxwellOutputConfig;
import com.zendesk.maxwell.schema.columndef.ColumnDefCastException;
import com.zendesk.maxwell.schema.columndef.ColumnDefWithLength;
import com.zendesk.maxwell.schema.columndef.DateFormatter;
import java.sql.Timestamp;

public class DateTimeColumnDef
extends ColumnDefWithLength {
    private final boolean isTimestamp = this.getType().equals("timestamp");

    private DateTimeColumnDef(String name, String type, short pos, Long columnLength) {
        super(name, type, pos, columnLength);
    }

    public static DateTimeColumnDef create(String name, String type, short pos, Long columnLength) {
        DateTimeColumnDef temp = new DateTimeColumnDef(name, type, pos, columnLength);
        return (DateTimeColumnDef)INTERNER.intern((Object)temp);
    }

    @Override
    protected String formatValue(Object value, MaxwellOutputConfig config) throws ColumnDefCastException {
        Long v;
        if (value instanceof Long && ((v = (Long)value) == Long.MIN_VALUE || v == 0L && this.isTimestamp)) {
            if (config.zeroDatesAsNull) {
                return null;
            }
            return DateTimeColumnDef.appendFractionalSeconds("0000-00-00 00:00:00", 0, this.getColumnLength());
        }
        try {
            Timestamp ts = DateFormatter.extractTimestamp(value);
            String dateString = DateFormatter.formatDateTime(value, ts);
            return DateTimeColumnDef.appendFractionalSeconds(dateString, ts.getNanos(), this.getColumnLength());
        }
        catch (IllegalArgumentException e) {
            throw new ColumnDefCastException(this, value);
        }
    }
}

