/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.ddl.ColumnMod;
import com.zendesk.maxwell.schema.ddl.DeferredPositionUpdate;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import java.util.List;

class RemoveColumnMod
extends ColumnMod {
    private final boolean ifExists;

    public RemoveColumnMod(String name, boolean ifExists) {
        super(name);
        this.ifExists = ifExists;
    }

    @Override
    public void apply(Table table, List<DeferredPositionUpdate> deferred) throws InvalidSchemaError {
        short originalIndex = table.findColumnIndex(this.name);
        if (originalIndex == -1) {
            if (this.ifExists) {
                return;
            }
            throw new InvalidSchemaError("Could not find column " + this.name + " in " + table.getName());
        }
        table.removeColumn(originalIndex);
    }
}

