/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedSchemaChange;

public class ResolvedTableAlter
extends ResolvedSchemaChange {
    public String database;
    public String table;
    @JsonProperty(value="old")
    public Table oldTable;
    @JsonProperty(value="def")
    public Table newTable;

    public ResolvedTableAlter() {
    }

    public ResolvedTableAlter(String database, String table, Table oldTable, Table newTable) {
        this();
        this.database = database;
        this.table = table;
        this.oldTable = oldTable;
        this.newTable = newTable;
    }

    @Override
    public void apply(Schema schema) throws InvalidSchemaError {
        Database oldDatabase = schema.findDatabaseOrThrow(this.database);
        Table table = oldDatabase.findTableOrThrow(this.table);
        Database newDatabase = this.database.equals(this.newTable.database) ? oldDatabase : schema.findDatabaseOrThrow(this.newTable.database);
        oldDatabase.removeTable(this.table);
        newDatabase.addTable(this.newTable);
    }

    @Override
    public String databaseName() {
        return this.database;
    }

    @Override
    public String tableName() {
        return this.table;
    }

    @Override
    public boolean shouldOutput(Filter filter) {
        return Filter.includes(filter, this.database, this.oldTable.getName()) && Filter.includes(filter, this.database, this.newTable.getName());
    }
}

