/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.schema.ddl;

import com.zendesk.maxwell.CaseSensitivity;
import com.zendesk.maxwell.filtering.Filter;
import com.zendesk.maxwell.schema.Database;
import com.zendesk.maxwell.schema.Schema;
import com.zendesk.maxwell.schema.Table;
import com.zendesk.maxwell.schema.columndef.ColumnDef;
import com.zendesk.maxwell.schema.ddl.InvalidSchemaError;
import com.zendesk.maxwell.schema.ddl.ResolvedTableCreate;
import com.zendesk.maxwell.schema.ddl.SchemaChange;
import java.util.ArrayList;
import java.util.List;

public class TableCreate
extends SchemaChange {
    public String database;
    public String table;
    public List<ColumnDef> columns;
    public List<String> pks;
    public String charset;
    public String likeDB;
    public String likeTable;
    public final boolean ifNotExists;

    public TableCreate(String database, String table, boolean ifNotExists) {
        this.database = database;
        this.table = table;
        this.ifNotExists = ifNotExists;
        this.columns = new ArrayList<ColumnDef>();
        this.pks = new ArrayList<String>();
    }

    @Override
    public ResolvedTableCreate resolve(Schema schema) throws InvalidSchemaError {
        Database d = schema.findDatabaseOrThrow(this.database);
        if (this.ifNotExists && d.hasTable(this.table)) {
            return null;
        }
        Table table = null;
        if (this.likeDB != null && this.likeTable != null) {
            table = this.resolveLikeTable(schema);
        } else {
            table = new Table(this.database, this.table, this.charset, this.columns, this.pks);
            this.resolveCharsets(d.getCharset(), table);
        }
        if (schema.getCaseSensitivity() == CaseSensitivity.CONVERT_TO_LOWER) {
            table.name = table.name.toLowerCase();
        }
        return new ResolvedTableCreate(table);
    }

    private Table resolveLikeTable(Schema schema) throws InvalidSchemaError {
        Database sourceDB = schema.findDatabaseOrThrow(this.likeDB);
        Table sourceTable = sourceDB.findTableOrThrow(this.likeTable);
        Table copiedTable = sourceTable.copy();
        copiedTable.database = this.database;
        copiedTable.name = this.table;
        return copiedTable;
    }

    private void resolveCharsets(String dbCharset, Table resolved) {
        resolved.charset = this.charset != null ? this.charset : dbCharset;
        resolved.setDefaultColumnCharsets();
    }

    @Override
    public boolean isBlacklisted(Filter filter) {
        if (filter == null) {
            return false;
        }
        return filter.isTableBlacklisted(this.database, this.table);
    }
}

