/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.util;

import com.zendesk.maxwell.util.RunState;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoppableTaskState {
    private static Logger LOGGER = LoggerFactory.getLogger(StoppableTaskState.class);
    private volatile RunState state = RunState.RUNNING;
    private final String description;

    public StoppableTaskState(String description) {
        this.description = description;
    }

    public boolean isRunning() {
        return this.state == RunState.RUNNING;
    }

    public synchronized void requestStop() {
        LOGGER.debug("{} requestStop() called (in state: {})", (Object)this.description, (Object)this.state);
        if (this.isRunning()) {
            this.state = RunState.REQUEST_STOP;
        }
    }

    public void stopped() {
        this.state = RunState.STOPPED;
    }

    public synchronized void awaitStop(Thread t, long timeoutMS) throws TimeoutException {
        for (long left = timeoutMS; left > 0L && this.state == RunState.REQUEST_STOP; left -= 10L) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (t != null) {
            t.interrupt();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.state != RunState.STOPPED) {
            throw new TimeoutException("Timed out trying waiting for " + this.description + " process to stop after " + timeoutMS + "ms.");
        }
    }

    public RunState getState() {
        return this.state;
    }
}

