/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.filtering;

import com.zendesk.maxwell.filtering.FilterPattern;
import com.zendesk.maxwell.filtering.FilterPatternType;
import com.zendesk.maxwell.filtering.FilterResult;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterColumnPattern
extends FilterPattern {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterColumnPattern.class);
    private final String columnName;
    private final Pattern columnPattern;
    private final boolean columnPatternIsNull;

    public FilterColumnPattern(FilterPatternType type, Pattern dbPattern, Pattern tablePattern, String columnName, Pattern columnPattern) {
        super(type, dbPattern, tablePattern);
        this.columnName = columnName;
        this.columnPattern = columnPattern;
        this.columnPatternIsNull = "^null$".equals(columnPattern.toString().toLowerCase());
    }

    @Override
    public void match(String database, String table, FilterResult match) {
    }

    @Override
    public void matchValue(String database, String table, Map<String, Object> data, FilterResult match) {
        boolean applyFilter = false;
        if (this.appliesTo(database, table) && data.containsKey(this.columnName)) {
            Object value = data.get(this.columnName);
            if (this.columnPatternIsNull) {
                if (value == null || "null".equals(value) || "NULL".equals(value)) {
                    applyFilter = true;
                }
            } else if (value == null) {
                if (this.columnPattern.pattern().length() == 0) {
                    applyFilter = true;
                }
            } else if (this.columnPattern.matcher(value.toString()).find()) {
                applyFilter = true;
            }
        }
        if (applyFilter) {
            match.include = this.type == FilterPatternType.INCLUDE;
        }
    }

    @Override
    public boolean couldIncludeColumn(String database, String table, Set<String> columns) {
        return this.type == FilterPatternType.INCLUDE && this.appliesTo(database, table) && columns.contains(this.columnName);
    }

    @Override
    public String toString() {
        String filterString = super.toString();
        return filterString + "." + this.columnName + "=" + this.patternToString(this.columnPattern);
    }
}

