/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.monitoring;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticResult;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticHealthCheckModule
extends Module {
    static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticHealthCheckModule.class);

    public String getModuleName() {
        return "diagnostic";
    }

    public Version version() {
        return new Version(0, 1, 0, "", "com.zendesk", "maxwell");
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new SimpleSerializers(Collections.singletonList(new DiagnosticHealthCheckResultSerializer())));
    }

    private static class DiagnosticHealthCheckResultSerializer
    extends StdSerializer<MaxwellDiagnosticResult> {
        private DiagnosticHealthCheckResultSerializer() {
            super(MaxwellDiagnosticResult.class);
        }

        public void serialize(MaxwellDiagnosticResult result, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeBooleanField("success", result.isSuccess());
            json.writeFieldName("checks");
            json.writeStartArray();
            result.getChecks().forEach(check -> this.serializeCheck(json, (MaxwellDiagnosticResult.Check)check));
            json.writeEndArray();
            json.writeEndObject();
        }

        private void serializeCheck(JsonGenerator json, MaxwellDiagnosticResult.Check check) {
            try {
                json.writeStartObject();
                json.writeStringField("name", check.getName());
                json.writeBooleanField("success", check.isSuccess());
                json.writeBooleanField("mandatory", check.isMandatory());
                if (check.getResource() != null) {
                    json.writeStringField("resource", check.getResource());
                }
                if (check.getInfo() != null) {
                    for (Map.Entry<String, String> entry : check.getInfo().entrySet()) {
                        json.writeStringField(entry.getKey(), entry.getValue());
                    }
                }
                json.writeEndObject();
            }
            catch (IOException e) {
                LOGGER.error("Could not serialize MaxwellDiagnosticResult.Check", (Throwable)e);
            }
        }
    }
}

