/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.google.api.core.ApiFutureCallback;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.common.collect.ImmutableList;
import com.zendesk.maxwell.MaxwellContext;
import com.zendesk.maxwell.producer.AbstractAsyncProducer;
import com.zendesk.maxwell.producer.AppendContext;
import com.zendesk.maxwell.producer.MaxwellBigQueryProducerWorker;
import com.zendesk.maxwell.replication.Position;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryCallback
implements ApiFutureCallback<AppendRowsResponse> {
    public final Logger LOGGER = LoggerFactory.getLogger(BigQueryCallback.class);
    private final MaxwellBigQueryProducerWorker parent;
    private final AbstractAsyncProducer.CallbackCompleter cc;
    private final Position position;
    private MaxwellContext context;
    AppendContext appendContext;
    private Counter succeededMessageCount;
    private Counter failedMessageCount;
    private Meter succeededMessageMeter;
    private Meter failedMessageMeter;
    private static final int MAX_RETRY_COUNT = 2;
    private final ImmutableList<Status.Code> RETRIABLE_ERROR_CODES = ImmutableList.of((Object)Status.Code.INTERNAL, (Object)Status.Code.ABORTED, (Object)Status.Code.CANCELLED);

    public BigQueryCallback(MaxwellBigQueryProducerWorker parent, AppendContext appendContext, AbstractAsyncProducer.CallbackCompleter cc, Position position, Counter producedMessageCount, Counter failedMessageCount, Meter succeededMessageMeter, Meter failedMessageMeter, MaxwellContext context) {
        this.parent = parent;
        this.appendContext = appendContext;
        this.cc = cc;
        this.position = position;
        this.succeededMessageCount = producedMessageCount;
        this.failedMessageCount = failedMessageCount;
        this.succeededMessageMeter = succeededMessageMeter;
        this.failedMessageMeter = failedMessageMeter;
        this.context = context;
    }

    public void onSuccess(AppendRowsResponse response) {
        this.succeededMessageCount.inc();
        this.succeededMessageMeter.mark();
        if (this.LOGGER.isDebugEnabled()) {
            try {
                this.LOGGER.debug("-> {}\n {}\n", (Object)this.appendContext.r.toJSON(), (Object)this.position);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cc.markCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Throwable t) {
        this.failedMessageCount.inc();
        this.failedMessageMeter.mark();
        this.LOGGER.error(t.getClass().getSimpleName() + " @ " + this.position);
        this.LOGGER.error(t.getLocalizedMessage());
        Status status = Status.fromThrowable((Throwable)t);
        if (this.appendContext.retryCount < 2 && this.RETRIABLE_ERROR_CODES.contains((Object)status.getCode())) {
            ++this.appendContext.retryCount;
            try {
                this.parent.sendAsync(this.appendContext.r, this.cc);
                return;
            }
            catch (Exception e) {
                System.out.format("Failed to retry append: %s\n", e);
            }
        }
        Object object = this.parent.getLock();
        synchronized (object) {
            if (this.parent.getError() == null && !this.context.getConfig().ignoreProducerError) {
                Exceptions.StorageException storageException = Exceptions.toStorageException((Throwable)t);
                this.parent.setError((RuntimeException)(storageException != null ? storageException : new RuntimeException(t)));
                this.context.terminate();
                return;
            }
        }
        this.cc.markCompleted();
    }
}

