/*
 * Decompiled with CFR 0.152.
 */
package com.zendesk.maxwell.producer;

import com.zendesk.maxwell.MaxwellConfig;
import com.zendesk.maxwell.monitoring.MaxwellDiagnostic;
import com.zendesk.maxwell.monitoring.MaxwellDiagnosticResult;
import com.zendesk.maxwell.producer.MaxwellKafkaProducerWorker;
import com.zendesk.maxwell.row.RowMap;
import com.zendesk.maxwell.schema.PositionStoreThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaProducerDiagnostic
implements MaxwellDiagnostic {
    private final MaxwellKafkaProducerWorker producer;
    private final MaxwellConfig config;
    private final PositionStoreThread positionStoreThread;

    public KafkaProducerDiagnostic(MaxwellKafkaProducerWorker producer, MaxwellConfig config, PositionStoreThread positionStoreThread) {
        this.producer = producer;
        this.config = config;
        this.positionStoreThread = positionStoreThread;
    }

    @Override
    public String getName() {
        return "kafka-producer";
    }

    @Override
    public CompletableFuture<MaxwellDiagnosticResult.Check> check() {
        return ((CompletableFuture)this.getLatency().thenApply(this::normalResult)).exceptionally(this::exceptionResult);
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public String getResource() {
        return this.config.getKafkaProperties().getProperty("bootstrap.servers");
    }

    public CompletableFuture<Long> getLatency() {
        DiagnosticCallback callback = new DiagnosticCallback();
        try {
            RowMap rowMap = new RowMap("insert", this.config.databaseName, "dummy", System.currentTimeMillis(), new ArrayList<String>(), this.positionStoreThread.getPosition());
            rowMap.setTXCommit();
            ProducerRecord<String, String> record = this.producer.makeProducerRecord(rowMap);
            this.producer.sendAsync(record, callback);
        }
        catch (Exception e) {
            callback.latency.completeExceptionally(e);
        }
        return callback.latency;
    }

    private MaxwellDiagnosticResult.Check normalResult(Long latency) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("message", "Kafka producer acknowledgement lag is " + latency.toString() + "ms");
        return new MaxwellDiagnosticResult.Check(this, true, info);
    }

    private MaxwellDiagnosticResult.Check exceptionResult(Throwable e) {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("error", e.getCause().toString());
        return new MaxwellDiagnosticResult.Check(this, false, info);
    }

    static class DiagnosticCallback
    implements Callback {
        final CompletableFuture<Long> latency = new CompletableFuture();
        final long sendTime = System.currentTimeMillis();

        DiagnosticCallback() {
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception == null) {
                this.latency.complete(System.currentTimeMillis() - this.sendTime);
            } else {
                this.latency.completeExceptionally(exception);
            }
        }
    }
}

